/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hosts;

import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.augeas.Augeas;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.augeas.AugeasConfigurationComponent;
import org.rhq.plugins.augeas.helper.AugeasNode;
import org.rhq.plugins.augeas.helper.AugeasUtility;
import org.rhq.plugins.hosts.helper.NonAugeasHostsConfigurationDelegate;

public class HostsComponent
extends AugeasConfigurationComponent {
    private static final String IPV4_ADDRESS_REGEX = "((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)";
    private static final Pattern IPV4_ADDRESS_PATTERN = Pattern.compile("((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)");
    private static final String IPV6_ADDRESS_REGEX = "((([0-9A-Fa-f]{1,4}:){7}(([0-9A-Fa-f]{1,4})|:))|(([0-9A-Fa-f]{1,4}:){6}(:|((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})|(:[0-9A-Fa-f]{1,4})))|(([0-9A-Fa-f]{1,4}:){5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){4}(:[0-9A-Fa-f]{1,4}){0,1}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){3}(:[0-9A-Fa-f]{1,4}){0,2}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){2}(:[0-9A-Fa-f]{1,4}){0,3}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:)(:[0-9A-Fa-f]{1,4}){0,4}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(:(:[0-9A-Fa-f]{1,4}){0,5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})))(%.+)?";
    private static final Pattern IPV6_ADDRESS_PATTERN = Pattern.compile("((([0-9A-Fa-f]{1,4}:){7}(([0-9A-Fa-f]{1,4})|:))|(([0-9A-Fa-f]{1,4}:){6}(:|((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})|(:[0-9A-Fa-f]{1,4})))|(([0-9A-Fa-f]{1,4}:){5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){4}(:[0-9A-Fa-f]{1,4}){0,1}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){3}(:[0-9A-Fa-f]{1,4}){0,2}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){2}(:[0-9A-Fa-f]{1,4}){0,3}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:)(:[0-9A-Fa-f]{1,4}){0,4}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(:(:[0-9A-Fa-f]{1,4}){0,5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})))(%.+)?");
    private static final String DOMAIN_NAME_REGEX = "(([a-zA-Z\\d]|[a-zA-Z\\d][a-zA-Z\\d\\-]*[a-zA-Z\\d])\\.)*([A-Za-z]|[A-Za-z][A-Za-z\\d\\-]*[A-Za-z\\d])";
    private static final Pattern DOMAIN_NAME_PATTERN = Pattern.compile("(([a-zA-Z\\d]|[a-zA-Z\\d][a-zA-Z\\d\\-]*[a-zA-Z\\d])\\.)*([A-Za-z]|[A-Za-z][A-Za-z\\d\\-]*[A-Za-z\\d])");
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        super.start(resourceContext);
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return super.getAvailability();
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration resourceConfig;
        if (this.isAugeasAvailable()) {
            resourceConfig = super.loadResourceConfiguration();
        } else {
            resourceConfig = new NonAugeasHostsConfigurationDelegate(this).loadResourceConfiguration();
            this.validateResourceConfiguration(new ConfigurationUpdateReport(resourceConfig));
        }
        return resourceConfig;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        if (this.isAugeasAvailable()) {
            super.updateResourceConfiguration(report);
        } else {
            if (!this.validateResourceConfiguration(report)) {
                this.log.debug((Object)("Validation of updated Resource configuration for " + this.getResourceDescription() + " failed with the following errors: " + report.getErrorMessage()));
                report.setStatus(ConfigurationUpdateStatus.FAILURE);
                return;
            }
            new NonAugeasHostsConfigurationDelegate(this).updateResourceConfiguration(report);
        }
    }

    protected String getNodeInsertionPoint(Augeas augeas, AugeasNode node, PropertyDefinitionSimple propDefSimple, PropertySimple propSimple) {
        if ("alias".equals(propSimple.getName())) {
            return String.format("%s/canonical", node.getParent().getPath());
        }
        return super.getNodeInsertionPoint(augeas, node, propDefSimple, propSimple);
    }

    protected AugeasNode getNewListMemberNode(AugeasNode listNode, PropertyDefinitionMap listMemberPropDefMap, int listIndex) {
        return new AugeasNode(listNode, "0" + listIndex);
    }

    protected boolean validateResourceConfiguration(ConfigurationUpdateReport report) {
        boolean isValid;
        Configuration resourceConfig = report.getConfiguration();
        StringBuilder errorMessage = new StringBuilder();
        HashSet<String> ipv4CanonicalNames = new HashSet<String>();
        HashSet<String> ipv6CanonicalNames = new HashSet<String>();
        HashSet<String> ipv4DuplicateCanonicalNames = new HashSet<String>();
        HashSet<String> ipv6DuplicateCanonicalNames = new HashSet<String>();
        HashSet<String> invalidDomainNameCanonicalNames = new HashSet<String>();
        HashSet<String> invalidIpAddressCanonicalNames = new HashSet<String>();
        HashSet invalidAliasCanonicalNames = new HashSet();
        PropertyList entries = resourceConfig.getList(".");
        for (Property entryProp : entries.getList()) {
            PropertySimple ipAddrProp;
            String ipaddr;
            PropertyMap entryPropMap = (PropertyMap)entryProp;
            PropertySimple canonicalProp = entryPropMap.getSimple("canonical");
            String canonical = canonicalProp.getStringValue();
            if (!this.validateDomainName(canonical)) {
                canonicalProp.setErrorMessage("Invalid domain name.");
                invalidDomainNameCanonicalNames.add(canonical);
            }
            if (!this.validateIpAddress(ipaddr = (ipAddrProp = entryPropMap.getSimple("ipaddr")).getStringValue())) {
                ipAddrProp.setErrorMessage("Invalid IP address.");
                invalidIpAddressCanonicalNames.add(canonical);
            }
            if (ipaddr.indexOf(58) != -1) {
                if (ipv6CanonicalNames.add(canonical)) continue;
                ipv6DuplicateCanonicalNames.add(canonical);
                continue;
            }
            if (ipv4CanonicalNames.add(canonical)) continue;
            ipv4DuplicateCanonicalNames.add(canonical);
        }
        if (!invalidDomainNameCanonicalNames.isEmpty()) {
            errorMessage.append("The entries with the following canonical names have invalid canonical names: ").append(invalidDomainNameCanonicalNames).append(".\n");
        }
        if (!invalidIpAddressCanonicalNames.isEmpty()) {
            errorMessage.append("The entries with the following canonical names have invalid IP addresses: ").append(invalidIpAddressCanonicalNames).append(".\n");
        }
        if (!invalidAliasCanonicalNames.isEmpty()) {
            errorMessage.append("The entries with the following canonical names have one or more invalid aliases: ").append(invalidAliasCanonicalNames).append(".\n");
        }
        if (!ipv4DuplicateCanonicalNames.isEmpty()) {
            errorMessage.append("More than one IPv4 address is defined for the following canonical names: ").append(ipv4DuplicateCanonicalNames).append(".\n");
        }
        if (!ipv6DuplicateCanonicalNames.isEmpty()) {
            errorMessage.append("More than one IPv6 address is defined for the following canonical names: ").append(ipv6DuplicateCanonicalNames).append(".\n");
        }
        if (errorMessage.length() != 0) {
            report.setErrorMessage(errorMessage.toString());
            isValid = false;
        } else {
            isValid = true;
        }
        return isValid;
    }

    protected AugeasNode getExistingChildNodeForListMemberPropertyMap(AugeasNode parentNode, PropertyDefinitionList propDefList, PropertyMap propMap) {
        String canonical;
        String canonicalFilter;
        Augeas augeas = this.getAugeas();
        List canonicalPaths = AugeasUtility.matchFilter((Augeas)augeas, (String)(canonicalFilter = parentNode.getPath() + "/*/canonical"), (String)(canonical = propMap.getSimple("canonical").getStringValue()));
        if (canonicalPaths.isEmpty()) {
            return null;
        }
        String ipaddr = propMap.getSimple("ipaddr").getStringValue();
        int ipAddressVersion = ipaddr.indexOf(58) == -1 ? 4 : 6;
        for (String canonicalPath : canonicalPaths) {
            AugeasNode canonicalNode = new AugeasNode(canonicalPath);
            AugeasNode childNode = canonicalNode.getParent();
            AugeasNode ipaddrNode = new AugeasNode(childNode, "ipaddr");
            String existingIpaddr = augeas.get(ipaddrNode.getPath());
            int existingIpAddressVersion = existingIpaddr.indexOf(58) == -1 ? 4 : 6;
            if (existingIpAddressVersion != ipAddressVersion) continue;
            return childNode;
        }
        return null;
    }

    private boolean validateIpAddress(String ipAddress) {
        Matcher ipv4Matcher = IPV4_ADDRESS_PATTERN.matcher(ipAddress);
        if (ipv4Matcher.matches()) {
            return true;
        }
        Matcher ipv6Matcher = IPV6_ADDRESS_PATTERN.matcher(ipAddress);
        return ipv6Matcher.matches();
    }

    private boolean validateDomainName(String domainName) {
        Matcher domainNameMatcher = DOMAIN_NAME_PATTERN.matcher(domainName);
        return domainNameMatcher.matches();
    }
}

