/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hosts.helper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.rhq.plugins.hosts.helper.HostsEntry;
import org.rhq.plugins.hosts.helper.SimpleUnixConfigFileLine;
import org.rhq.plugins.hosts.helper.SimpleUnixConfigFileReader;

public class Hosts {
    private static final Log LOG = LogFactory.getLog(Hosts.class);
    private Set<HostsEntry> entries = new LinkedHashSet<HostsEntry>();
    private Map<String, Set<HostsEntry>> nameToIpv4EntriesMap = new HashMap<String, Set<HostsEntry>>();
    private Map<String, Set<HostsEntry>> nameToIpv6EntriesMap = new HashMap<String, Set<HostsEntry>>();

    public void addEntry(HostsEntry entry) {
        this.entries.add(entry);
        String canonicalName = entry.getCanonicalName();
        this.updateNameToEntriesMaps(entry, canonicalName);
    }

    private void updateNameToEntriesMaps(HostsEntry entry, String canonicalName) {
        Map<String, Set<HostsEntry>> nameToEntriesMap = entry.getIpVersion() == 4 ? this.nameToIpv4EntriesMap : this.nameToIpv6EntriesMap;
        Set<HostsEntry> entriesForCanonicalName = nameToEntriesMap.get(canonicalName);
        if (entriesForCanonicalName == null) {
            entriesForCanonicalName = new LinkedHashSet<HostsEntry>(1);
            nameToEntriesMap.put(canonicalName, entriesForCanonicalName);
        }
        entriesForCanonicalName.add(entry);
    }

    public Set<HostsEntry> getEntries() {
        return this.entries;
    }

    public Set<HostsEntry> getIpv4EntriesByName(String canonicalName) {
        Set<HostsEntry> entries = this.nameToIpv4EntriesMap.get(canonicalName);
        return entries != null ? entries : Collections.emptySet();
    }

    public Set<HostsEntry> getIpv6EntriesByName(String canonicalName) {
        Set<HostsEntry> entries = this.nameToIpv6EntriesMap.get(canonicalName);
        return entries != null ? entries : Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hosts load(File hostsFile) throws IOException {
        Hosts hosts = new Hosts();
        SimpleUnixConfigFileReader reader = new SimpleUnixConfigFileReader(new FileReader(hostsFile));
        try {
            SimpleUnixConfigFileLine line;
            while ((line = reader.readLine()) != null) {
                String nonComment = line.getNonComment();
                HostsEntry entry = Hosts.parseEntry(nonComment, hostsFile);
                if (entry == null) continue;
                hosts.addEntry(entry);
            }
        }
        finally {
            reader.close();
        }
        return hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(Hosts hosts, File hostsFile) throws IOException {
        boolean updateSucceeded;
        boolean backupSucceeded;
        if (!hostsFile.exists()) {
            FileOutputStream hostsFileWriter = new FileOutputStream(hostsFile);
            hostsFileWriter.close();
        }
        HashSet<String> storedIpv4CanonicalNames = new HashSet<String>();
        HashSet<String> storedIpv6CanonicalNames = new HashSet<String>();
        File newHostsFile = new File(hostsFile.getPath() + "-" + System.currentTimeMillis());
        PrintWriter newHostsFileWriter = new PrintWriter(new FileWriter(newHostsFile));
        try {
            SimpleUnixConfigFileReader hostsFileReader = new SimpleUnixConfigFileReader(new FileReader(hostsFile));
            try {
                SimpleUnixConfigFileLine line;
                while ((line = hostsFileReader.readLine()) != null) {
                    StringBuilder newLine = Hosts.createNewLine(hosts, hostsFile, line, storedIpv4CanonicalNames, storedIpv6CanonicalNames);
                    if (newLine == null) continue;
                    newHostsFileWriter.println(newLine);
                }
            }
            finally {
                hostsFileReader.close();
            }
            for (HostsEntry newEntry : hosts.getEntries()) {
                HashSet<String> storedCanonicalNames = newEntry.getIpVersion() == 4 ? storedIpv4CanonicalNames : storedIpv6CanonicalNames;
                if (storedCanonicalNames.contains(newEntry.getCanonicalName())) continue;
                StringBuilder newLine = new StringBuilder(newEntry.getIpAddress()).append("\t").append(newEntry.getCanonicalName());
                for (String alias : newEntry.getAliases()) {
                    newLine.append("\t").append(alias);
                }
                newHostsFileWriter.println(newLine);
            }
        }
        finally {
            newHostsFileWriter.close();
        }
        File backupHostsFile = new File(hostsFile.getPath() + "~");
        if (backupHostsFile.exists()) {
            boolean deleteSucceeded = backupHostsFile.delete();
        }
        if (!(backupSucceeded = hostsFile.renameTo(backupHostsFile))) {
            throw new IOException("Failed to backup original hosts file [" + hostsFile + "] to [" + backupHostsFile + "].");
        }
        if (hostsFile.exists()) {
            boolean deleteSucceeded = hostsFile.delete();
        }
        if (!(updateSucceeded = newHostsFile.renameTo(hostsFile))) {
            throw new IOException("Failed to rename updated hosts file [" + newHostsFile + "] to [" + hostsFile + "].");
        }
    }

    private static HostsEntry parseEntry(String string, File hostsFile) {
        if (string == null) {
            return null;
        }
        String trimmedString = string.trim();
        if (trimmedString.equals("")) {
            return null;
        }
        String[] tokens = trimmedString.split("\\s+");
        if (tokens.length == 0) {
            return null;
        }
        String ipAddress = tokens[0];
        if (tokens.length == 1) {
            LOG.warn((Object)("Hosts file [" + hostsFile + "] contains invalid entry for IP address " + ipAddress + " - no canonical name is specified."));
        }
        String canonicalName = null;
        LinkedHashSet<String> aliasSet = null;
        if (tokens.length >= 2) {
            canonicalName = tokens[1];
            if (tokens.length >= 3) {
                aliasSet = new LinkedHashSet<String>(tokens.length - 2);
                for (int i = 2; i < tokens.length; ++i) {
                    aliasSet.add(tokens[i]);
                }
            }
        }
        return new HostsEntry(ipAddress, canonicalName, aliasSet);
    }

    @Nullable
    private static StringBuilder createNewLine(Hosts hosts, File hostsFile, SimpleUnixConfigFileLine existingLine, Set<String> storedIpv4CanonicalNames, Set<String> storedIpv6CanonicalNames) {
        StringBuilder newLine;
        String nonComment = existingLine.getNonComment();
        String comment = existingLine.getComment();
        HostsEntry existingEntry = Hosts.parseEntry(nonComment, hostsFile);
        if (existingEntry != null) {
            Set<HostsEntry> newEntries;
            Set<HostsEntry> set = newEntries = existingEntry.getIpVersion() == 4 ? hosts.getIpv4EntriesByName(existingEntry.getCanonicalName()) : hosts.getIpv6EntriesByName(existingEntry.getCanonicalName());
            if (!newEntries.isEmpty()) {
                HostsEntry newEntry = newEntries.iterator().next();
                LOG.debug((Object)("Replacing existing entry in hosts file [" + existingEntry + "] with new entry [" + newEntry + "]..."));
                newLine = new StringBuilder(newEntry.getIpAddress()).append("\t").append(newEntry.getCanonicalName());
                for (String alias : newEntry.getAliases()) {
                    newLine.append("\t").append(alias);
                }
                if (comment != null) {
                    newLine.append(" #").append(comment);
                }
                Set<String> storedCanonicalNames = newEntry.getIpVersion() == 4 ? storedIpv4CanonicalNames : storedIpv6CanonicalNames;
                storedCanonicalNames.add(newEntry.getCanonicalName());
            } else {
                LOG.debug((Object)("Removing entry [" + existingEntry + "] from hosts file..."));
                newLine = null;
            }
        } else {
            newLine = new StringBuilder();
            if (nonComment != null) {
                newLine.append(nonComment);
            }
            if (comment != null) {
                newLine.append('#').append(comment);
            }
        }
        return newLine;
    }
}

