/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.iis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hyperic.sigar.win32.Pdh;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.iis.IISServerComponent;
import org.rhq.plugins.iis.util.IISMetaBase;

public class IISVHostDiscoveryComponent
implements ResourceDiscoveryComponent<IISServerComponent<?>> {
    private static final String PDH_WEB_SERVICE = "Web Service";
    private static final String PDH_TOTAL = "_Total";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<IISServerComponent<?>> resourceDiscoveryContext) throws InvalidPluginConfigurationException, Exception {
        ArrayList<String> vhosts = new ArrayList<String>();
        String[] instances = Pdh.getInstances((String)PDH_WEB_SERVICE);
        HashSet<DiscoveredResourceDetails> hostDetails = new HashSet<DiscoveredResourceDetails>();
        for (String instance : instances) {
            if (instance.equals(PDH_TOTAL)) continue;
            vhosts.add(instance);
        }
        Map<String, IISMetaBase> websites = IISMetaBase.getWebSites();
        for (String siteName : vhosts) {
            IISMetaBase info = websites.get(siteName);
            if (info == null) continue;
            Configuration config = resourceDiscoveryContext.getDefaultPluginConfiguration();
            config.put((Property)new PropertySimple("siteName", (Object)siteName));
            config.put((Property)new PropertySimple("port", (Object)info.getPort()));
            config.put((Property)new PropertySimple("ipAddress", (Object)info.getIp()));
            config.put((Property)new PropertySimple("docRoot", (Object)info.getPath()));
            config.put((Property)new PropertySimple("hostname", (Object)info.getHostname()));
            config.put((Property)new PropertySimple("ssl", (Object)info.isRequireSSL()));
            config.put((Property)new PropertySimple("logDirectory", (Object)("C:\\Windows\\System32\\LogFiles\\W3SVC" + info.getId())));
            DiscoveredResourceDetails details = new DiscoveredResourceDetails(resourceDiscoveryContext.getResourceType(), siteName, siteName, "1.0", siteName + " Virtual Host", config, null);
            hostDetails.add(details);
        }
        return hostDetails;
    }
}

