/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ReadChildrenNames;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class QueryCacheDiscovery
implements ResourceDiscoveryComponent<BaseComponent<?>> {
    private static final String QUERY_CACHE_TYPE_NAME = "query-cache";
    private static final String RESOURCE_NAME_PREFIX = "Query Cache ";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<BaseComponent<?>> context) throws InvalidPluginConfigurationException {
        BaseComponent parentComponent = (BaseComponent)context.getParentResourceComponent();
        String parentComponentPath = parentComponent.getPath();
        Address parentAddress = new Address(parentComponentPath);
        Result readChildrenNamesResult = parentComponent.getASConnection().execute(new ReadChildrenNames(parentAddress, QUERY_CACHE_TYPE_NAME));
        if (readChildrenNamesResult.isSuccess()) {
            HashSet<DiscoveredResourceDetails> details = new HashSet<DiscoveredResourceDetails>();
            List childrenNames = (List)readChildrenNamesResult.getResult();
            for (String childName : childrenNames) {
                Configuration pluginConfiguration = context.getDefaultPluginConfiguration();
                pluginConfiguration.setSimpleValue("path", parentComponentPath + "," + QUERY_CACHE_TYPE_NAME + "=" + childName);
                String resourceKey = MessageDigestGenerator.getDigestString((String)childName);
                details.add(new DiscoveredResourceDetails(context.getResourceType(), resourceKey, RESOURCE_NAME_PREFIX + resourceKey, null, context.getResourceType().getDescription(), pluginConfiguration, null));
            }
            return details;
        }
        return Collections.emptySet();
    }
}

