/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.rhq.modules.plugins.jbossas7.ASConnectionParams;

class SchemeRegistryBuilder {
    private static final TrustSelfSignedStrategy TRUST_SELF_SIGNED_STRATEGY = new TrustSelfSignedStrategy();
    private static final TrustAnyStrategy TRUST_ANY_STRATEGY = new TrustAnyStrategy();
    private final ASConnectionParams asConnectionParams;

    public SchemeRegistryBuilder(ASConnectionParams asConnectionParams) {
        this.asConnectionParams = asConnectionParams;
    }

    public SchemeRegistry buildSchemeRegistry() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        if (this.asConnectionParams.isSecure()) {
            SSLSocketFactory sslSocketFactory;
            try {
                KeyStore truststore = null;
                if (this.asConnectionParams.getTruststore() != null) {
                    truststore = this.loadKeystore(this.asConnectionParams.getTruststoreType(), this.asConnectionParams.getTruststore(), this.asConnectionParams.getTruststorePassword());
                }
                KeyStore keystore = null;
                String keyPassword = null;
                if (this.asConnectionParams.isClientcertAuthentication()) {
                    if (this.asConnectionParams.getKeystore() == null) {
                        keystore = this.loadKeystore(System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()), System.getProperty("javax.net.ssl.keyStore"), System.getProperty("javax.net.ssl.keyStorePassword"));
                    } else {
                        keystore = this.loadKeystore(this.asConnectionParams.getKeystoreType(), this.asConnectionParams.getKeystore(), this.asConnectionParams.getKeystorePassword());
                        keyPassword = this.asConnectionParams.getKeyPassword();
                    }
                }
                sslSocketFactory = new SSLSocketFactory(null, keystore, keyPassword, truststore, null, this.getTrustStrategy(), this.getHostnameVerifier());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            schemeRegistry.register(new Scheme("https", this.asConnectionParams.getPort(), (SchemeSocketFactory)sslSocketFactory));
        } else {
            schemeRegistry.register(new Scheme("http", this.asConnectionParams.getPort(), (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        }
        return schemeRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadKeystore(String keystoreType, String keystore, String keystorePassword) throws Exception {
        KeyStore ks = KeyStore.getInstance(keystoreType);
        char[] password = keystorePassword.toCharArray();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(keystore);
            ks.load(fileInputStream, password);
            KeyStore keyStore = ks;
            return keyStore;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private TrustStrategy getTrustStrategy() {
        switch (this.asConnectionParams.getTrustStrategy()) {
            case TRUST_SELFSIGNED: {
                return TRUST_SELF_SIGNED_STRATEGY;
            }
            case TRUST_ANY: {
                return TRUST_ANY_STRATEGY;
            }
            case STANDARD: {
                return null;
            }
        }
        throw new UnsupportedOperationException(this.asConnectionParams.getTrustStrategy().name);
    }

    private X509HostnameVerifier getHostnameVerifier() {
        switch (this.asConnectionParams.getHostnameVerification()) {
            case STRICT: {
                return SSLSocketFactory.STRICT_HOSTNAME_VERIFIER;
            }
            case BROWSER_COMPATIBLE: {
                return SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
            }
            case SKIP: {
                return SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
            }
        }
        throw new UnsupportedOperationException(this.asConnectionParams.getHostnameVerification().name);
    }

    private static class TrustAnyStrategy
    implements TrustStrategy {
        private TrustAnyStrategy() {
        }

        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            return true;
        }
    }
}

