/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.concurrent.TimeUnit;
import org.rhq.modules.plugins.jbossas7.ASConnectionParamsBuilder;
import org.rhq.modules.plugins.jbossas7.helper.HostnameVerification;
import org.rhq.modules.plugins.jbossas7.helper.ServerPluginConfiguration;
import org.rhq.modules.plugins.jbossas7.helper.TrustStrategy;

public final class ASConnectionParams {
    public static final int DEFAULT_KEEPALIVE_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(5L);
    private final String host;
    private final int port;
    private final boolean secure;
    private final String username;
    private final String password;
    private final long keepAliveTimeout;
    private final TrustStrategy trustStrategy;
    private final HostnameVerification hostnameVerification;
    private final String truststoreType;
    private final String truststore;
    private final String truststorePassword;
    private final boolean clientcertAuthentication;
    private final String keystoreType;
    private final String keystore;
    private final String keystorePassword;
    private final String keyPassword;

    ASConnectionParams(String host, int port, boolean secure, String username, String password, Long keepAliveTimeout, TrustStrategy trustStrategy, HostnameVerification hostnameVerification, String truststoreType, String truststore, String truststorePassword, boolean clientcertAuthentication, String keystoreType, String keystore, String keystorePassword, String keyPassword) {
        this.host = host;
        this.port = port;
        this.secure = secure;
        this.username = username;
        this.password = password;
        this.keyPassword = keyPassword;
        this.keepAliveTimeout = keepAliveTimeout != null ? keepAliveTimeout : (long)DEFAULT_KEEPALIVE_TIMEOUT;
        this.trustStrategy = trustStrategy;
        this.hostnameVerification = hostnameVerification;
        this.truststoreType = truststoreType;
        this.truststore = truststore;
        this.truststorePassword = truststorePassword;
        this.clientcertAuthentication = clientcertAuthentication;
        this.keystoreType = keystoreType;
        this.keystore = keystore;
        this.keystorePassword = keystorePassword;
    }

    public static ASConnectionParams createFrom(ServerPluginConfiguration serverPluginConfig) {
        return new ASConnectionParamsBuilder().setHost(serverPluginConfig.getHostname()).setPort(serverPluginConfig.getPort()).setSecure(serverPluginConfig.isSecure()).setUsername(serverPluginConfig.getUser()).setPassword(serverPluginConfig.getPassword()).setKeepAliveTimeout(serverPluginConfig.getManagementConnectionTimeout()).setTrustStrategy(serverPluginConfig.getTrustStrategy()).setHostnameVerification(serverPluginConfig.getHostnameVerification()).setTruststoreType(serverPluginConfig.getTruststoreType()).setTruststore(serverPluginConfig.getTruststore()).setTruststorePassword(serverPluginConfig.getTruststorePassword()).setClientcertAuthentication(serverPluginConfig.isClientcertAuthentication()).setKeystoreType(serverPluginConfig.getKeystoreType()).setKeystore(serverPluginConfig.getKeystore()).setKeystorePassword(serverPluginConfig.getKeystorePassword()).setKeyPassword(serverPluginConfig.getKeyPassword()).createASConnectionParams();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public TrustStrategy getTrustStrategy() {
        return this.trustStrategy;
    }

    public HostnameVerification getHostnameVerification() {
        return this.hostnameVerification;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public String getTruststore() {
        return this.truststore;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public boolean isClientcertAuthentication() {
        return this.clientcertAuthentication;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }
}

