/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pluginapi.util.ProcessExecutionUtility;
import org.rhq.core.pluginapi.util.StartScriptConfiguration;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.rhq.modules.plugins.jbossas7.helper.ServerPluginConfiguration;
import org.rhq.modules.plugins.jbossas7.util.ProcessExecutionLogger;
import org.rhq.modules.plugins.jbossas7.util.PropertyReplacer;

class CliExecutor {
    private static final Log LOG = LogFactory.getLog(CliExecutor.class);
    private final AS7Mode serverMode;
    private final ServerPluginConfiguration serverPluginConfig;
    private final StartScriptConfiguration startScriptConfig;
    private final SystemInfo systemInfo;

    CliExecutor(AS7Mode serverMode, ServerPluginConfiguration serverPluginConfig, StartScriptConfiguration startScriptConfig, SystemInfo systemInfo) {
        this.serverMode = serverMode;
        this.serverPluginConfig = serverPluginConfig;
        this.startScriptConfig = startScriptConfig;
        this.systemInfo = systemInfo;
    }

    ProcessExecutionResults executeCliCommand(String commands, long waitTime, boolean killOnTimeout) {
        StringBuilder additionalArg = new StringBuilder(commands.length());
        Scanner scanner = new Scanner(commands);
        while (scanner.hasNextLine()) {
            additionalArg.append(scanner.nextLine());
            if (!scanner.hasNextLine()) continue;
            additionalArg.append(",");
        }
        return this.executeCli(Arrays.asList(additionalArg.toString()), waitTime, killOnTimeout);
    }

    ProcessExecutionResults executeCliScript(String scriptFile, long waitTime, boolean killOnTimeout) {
        List<String> additionalArgs = Arrays.asList("--file=" + scriptFile);
        return this.executeCli(additionalArgs, waitTime, killOnTimeout);
    }

    ProcessExecutionResults executeCli(List<String> additionalArgs, long waitTime, boolean killOnTimeout) {
        File startScriptFile = new File(new File(this.serverPluginConfig.getHomeDir(), "bin"), this.serverMode.getCliScriptFileName());
        ProcessExecution processExecution = ProcessExecutionUtility.createProcessExecution((File)startScriptFile);
        processExecution.setArguments(new ArrayList(15));
        List arguments = processExecution.getArguments();
        arguments.add("--connect");
        arguments.add("--user=" + this.serverPluginConfig.getUser());
        arguments.add("--password=" + this.serverPluginConfig.getPassword());
        arguments.add("--controller=" + this.serverPluginConfig.getNativeHost() + ":" + this.serverPluginConfig.getNativePort());
        arguments.addAll(additionalArgs);
        Map startScriptEnv = this.startScriptConfig.getStartScriptEnv();
        for (String envVarName : startScriptEnv.keySet()) {
            String envVarValue = (String)startScriptEnv.get(envVarName);
            envVarValue = PropertyReplacer.replacePropertyPatterns(envVarValue, this.serverPluginConfig.getPluginConfig());
            startScriptEnv.put(envVarName, envVarValue);
        }
        processExecution.setEnvironmentVariables(startScriptEnv);
        processExecution.setWorkingDirectory(startScriptFile.getParent());
        processExecution.setCaptureOutput(true);
        processExecution.setWaitForCompletion(waitTime);
        processExecution.setKillOnTimeout(killOnTimeout);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("About to execute the following process: [" + processExecution + "]"));
        }
        ProcessExecutionResults results = this.systemInfo.executeProcess(processExecution);
        ProcessExecutionLogger.logExecutionResults(results);
        return results;
    }
}

