/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.DeploymentComponent;
import org.rhq.modules.plugins.jbossas7.HostControllerComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.CompositeOperation;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.ReadChildrenNames;
import org.rhq.modules.plugins.jbossas7.json.ReadChildrenResources;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class DomainDeploymentComponent
extends DeploymentComponent
implements OperationFacet {
    @Override
    public AvailabilityType getAvailability() {
        ReadResource op = new ReadResource(this.getAddress());
        Result res = this.getASConnection().execute((Operation)op, 60);
        if (res != null && res.isSuccess()) {
            return AvailabilityType.UP;
        }
        if (res != null && !res.isSuccess() && res.isTimedout()) {
            return AvailabilityType.UNKNOWN;
        }
        return AvailabilityType.MISSING;
    }

    private String getManagementNodeName() {
        String managementNodeName = this.context.getResourceKey();
        return managementNodeName.substring(managementNodeName.indexOf("=") + 1);
    }

    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        OperationResult operationResult = new OperationResult();
        if (name.equals("promote")) {
            String serverGroup = parameters.getSimpleValue("server-group", "-not set-");
            ArrayList<String> serverGroups = new ArrayList<String>();
            if (serverGroup.equals("__all")) {
                serverGroups.addAll(this.getServerGroups());
            } else {
                serverGroups.add(serverGroup);
            }
            String managementNodeName = this.getManagementNodeName();
            DomainDeploymentComponent.getLog().info((Object)("Promoting [" + managementNodeName + "] to server group(s) [" + serverGroups + "]..."));
            PropertySimple simple = parameters.getSimple("enabled");
            Boolean enabled = false;
            if (simple != null && simple.getBooleanValue() != null) {
                enabled = simple.getBooleanValue();
            }
            PropertySimple runtimeNameProperty = parameters.getSimple("runtime-name");
            String runtimeName = null;
            if (runtimeNameProperty != null) {
                runtimeName = runtimeNameProperty.getStringValue();
            }
            CompositeOperation operation = new CompositeOperation();
            for (String theGroup : serverGroups) {
                Operation step = this.createServerGroupAssignmentStep("add", theGroup, runtimeName, enabled);
                operation.addStep(step);
            }
            Result res = this.getASConnection().execute((Operation)operation, 120);
            if (res.isSuccess()) {
                operationResult.setSimpleResult("Successfully deployed to server groups " + serverGroups);
                this.requestDiscovery();
            } else {
                operationResult.setErrorMessage("Deployment to server groups failed: " + res.getFailureDescription());
            }
        } else if (name.equals("restart")) {
            String serverGroup = parameters.getSimpleValue("server-group", "-not set-");
            ArrayList<String> serverGroups = new ArrayList<String>();
            List<String> assignedGroups = this.findAssignedServerGroups();
            if (serverGroup.equals("__all")) {
                serverGroups.addAll(assignedGroups);
            } else {
                if (!assignedGroups.contains(serverGroup)) {
                    operationResult.setErrorMessage("Deployment could not be restarted in server-group [" + serverGroup + "] because it is not assigned to it.");
                    return operationResult;
                }
                serverGroups.add(serverGroup);
            }
            if (serverGroups.isEmpty()) {
                operationResult.setErrorMessage("Deployment could not be restarted because it is not assigned to any server-group");
                return operationResult;
            }
            CompositeOperation operation = new CompositeOperation();
            for (String theGroup : serverGroups) {
                Operation step = this.createServerGroupAssignmentStep("redeploy", theGroup, null, false);
                operation.addStep(step);
            }
            Result res = this.getASConnection().execute((Operation)operation, 120);
            if (res.isSuccess()) {
                operationResult.setSimpleResult("Successfully restarted in server groups " + serverGroups);
            } else {
                operationResult.setErrorMessage("Deployment restart in server groups failed: " + res.getFailureDescription());
            }
        } else {
            operationResult.setErrorMessage("Unknown operation " + name);
        }
        return operationResult;
    }

    private void requestDiscovery() {
        if (this.context.getParentResourceComponent().getClass().isInstance(HostControllerComponent.class)) {
            HostControllerComponent hostController = (HostControllerComponent)this.context.getParentResourceComponent();
            hostController.requestDeferredChildResourcesDiscovery();
        }
    }

    private List<String> findAssignedServerGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        Configuration config = new Configuration();
        this.loadAssignedServerGroups(config);
        for (Property prop : config.getList("*1").getList()) {
            PropertyMap map = (PropertyMap)prop;
            groups.add(map.getSimpleValue("server-group", null));
        }
        return groups;
    }

    private void loadAssignedServerGroups(Configuration configuration) {
        String managementNodeName = this.getManagementNodeName();
        Address theAddress = new Address("/");
        ReadChildrenResources op = new ReadChildrenResources(theAddress, "server-group");
        op.addAdditionalProperty("recursive-depth", "1");
        Result res = this.getASConnection().execute(op);
        PropertyList propGroups = new PropertyList("*1");
        configuration.put((Property)propGroups);
        if (res.isSuccess()) {
            Map groups = (Map)res.getResult();
            for (Map.Entry entry : groups.entrySet()) {
                Map deployment;
                Map groupDetails = (Map)entry.getValue();
                Map deployments = (Map)groupDetails.get("deployment");
                if (deployments == null || (deployment = (Map)deployments.get(managementNodeName)) == null) continue;
                PropertyMap map = new PropertyMap("*");
                map.put((Property)new PropertySimple("server-group", entry.getKey()));
                map.put((Property)new PropertySimple("runtime-name", deployment.get("runtime-name")));
                map.put((Property)new PropertySimple("enabled", deployment.get("enabled")));
                propGroups.add((Property)map);
            }
        }
    }

    private Operation createServerGroupAssignmentStep(String action, String serverGroup, String runtimeName, boolean enabled) {
        Address addr = new Address();
        addr.add("server-group", serverGroup);
        addr.add("deployment", this.getManagementNodeName());
        Operation op = new Operation(action, addr);
        if ("add".equals(action)) {
            if (runtimeName != null && !runtimeName.isEmpty()) {
                op.addAdditionalProperty("runtime-name", runtimeName);
            }
            op.addAdditionalProperty("enabled", enabled);
        }
        return op;
    }

    @Override
    public Configuration loadResourceConfiguration() throws Exception {
        Configuration configuration = new Configuration();
        Operation op = new Operation("read-resource", this.getAddress());
        Result res = this.getASConnection().execute(op);
        if (!res.isSuccess()) {
            throw new IOException("Operation " + op + " failed: " + res.getFailureDescription());
        }
        Map result = (Map)res.getResult();
        configuration.put((Property)new PropertySimple("name", result.get("name")));
        configuration.put((Property)new PropertySimple("runtime-name", result.get("runtime-name")));
        configuration.put((Property)new PropertySimple("content", result.get("content")));
        DomainDeploymentComponent.includeOOBMessages(res, configuration);
        this.loadAssignedServerGroups(configuration);
        return configuration;
    }

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Configuration sgConfig = new Configuration();
        this.loadAssignedServerGroups(sgConfig);
        CompositeOperation operation = new CompositeOperation();
        boolean needDiscovery = false;
        HashMap<String, PropertyMap> assignedCurrent = new HashMap<String, PropertyMap>();
        for (Property p : sgConfig.getList("*1").getList()) {
            PropertyMap map = (PropertyMap)p;
            assignedCurrent.put(map.getSimpleValue("server-group", null), map);
        }
        HashMap<String, PropertyMap> assignedNew = new HashMap<String, PropertyMap>();
        for (Property prop : report.getConfiguration().getList("*1").getList()) {
            PropertyMap mapNew = (PropertyMap)prop;
            PropertyMap duplicate = assignedNew.put(mapNew.getSimpleValue("server-group", null), mapNew);
            if (duplicate != null) {
                report.setStatus(ConfigurationUpdateStatus.FAILURE);
                report.setErrorMessage("Duplicate assignment to [" + duplicate.getSimpleValue("server-group", null) + "] you cannot assign deployment to server-group more than once");
                return;
            }
            String key = mapNew.getSimpleValue("server-group", null);
            String runtimeNew = mapNew.getSimpleValue("runtime-name", null);
            boolean enabledNew = mapNew.getSimple("enabled").getBooleanValue();
            PropertyMap mapCurrent = (PropertyMap)assignedCurrent.remove(key);
            if (mapCurrent == null) {
                operation.addStep(this.createServerGroupAssignmentStep("add", key, runtimeNew, enabledNew));
                needDiscovery = true;
                continue;
            }
            boolean enabledCurrent = mapCurrent.getSimple("enabled").getBooleanValue();
            if (enabledCurrent == enabledNew) continue;
            String action = "undeploy";
            if (enabledNew) {
                action = "deploy";
            }
            operation.addStep(this.createServerGroupAssignmentStep(action, key, null, false));
        }
        for (PropertyMap map : assignedCurrent.values()) {
            operation.addStep(this.createServerGroupAssignmentStep("remove", map.getSimpleValue("server-group", null), null, false));
        }
        if (operation.numberOfSteps() == 0) {
            report.setStatus(ConfigurationUpdateStatus.NOCHANGE);
            return;
        }
        Result res = this.getASConnection().execute((Operation)operation, 120);
        if (!res.isSuccess()) {
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessage(res.getFailureDescription());
            return;
        }
        report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        if (needDiscovery) {
            this.requestDiscovery();
        }
    }

    private Collection<String> getServerGroups() {
        ReadChildrenNames op = new ReadChildrenNames(new Address(), "server-group");
        Result res = this.getASConnection().execute(op);
        return (Collection)res.getResult();
    }
}

