/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.ConfigurationLoadDelegate;
import org.rhq.modules.plugins.jbossas7.ConfigurationWriteDelegate;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.ReadChildrenNames;
import org.rhq.modules.plugins.jbossas7.json.Result;
import org.rhq.modules.plugins.jbossas7.json.WriteAttribute;

public class ModuleOptionsComponent
extends BaseComponent
implements ConfigurationFacet,
DeleteResourceFacet,
CreateChildResourceFacet {
    private static String moduleOptionsNode = ",module-options";
    private static String loginModules = "login-modules";
    private static String aclModules = "acl-modules";
    private static String providerModules = "provider-modules";
    private static String policyModules = "policy-modules";
    private static String trustModules = "trust-modules";
    private static String mappingModules = "mapping-modules";
    private static String authModules = "auth-modules";
    private static String AUTH_CLASSIC_NODE = "Authentication (Classic";
    private static String AUTH_JASPI_NODE = "Authentication (Jaspi";
    private static String ACL_NODE = "ACL";
    private static String AUDIT_NODE = "Audit";
    private static String AUTHORIZATION_NODE = "Authorization";
    private static String TRUST_NODE = "Identity Trust";
    private static String MAPPING_NODE = "Mapping";
    private static String[] supportedModuleOptionTypeNodes = new String[]{AUTH_CLASSIC_NODE, AUTH_JASPI_NODE, ACL_NODE, AUDIT_NODE, AUTHORIZATION_NODE, TRUST_NODE, MAPPING_NODE};
    public static HashMap<String, String> attributeMap = new HashMap();
    public static HashMap<String, String> newChildTypeMap;

    @Override
    public CreateResourceReport createResource(CreateResourceReport report) {
        if (report.getPackageDetails() != null) {
            return this.deployContent(report);
        }
        ASConnection connection = this.getASConnection();
        boolean isSingleton = report.getResourceType().isSingleton();
        if (isSingleton) {
            List entries;
            Configuration pluginConfig = report.getPluginConfiguration();
            PropertySimple pathProperty = pluginConfig.getSimple("path");
            if (this.path == null || this.path.isEmpty()) {
                report.setErrorMessage("No path property found in plugin configuration");
                report.setStatus(CreateResourceStatus.INVALID_CONFIGURATION);
                return report;
            }
            ReadChildrenNames op = new ReadChildrenNames(this.address, pathProperty.getStringValue());
            Result res = connection.execute(op);
            if (res.isSuccess() && !(entries = (List)res.getResult()).isEmpty()) {
                report.setErrorMessage("Resource is a singleton, but there are already children " + entries + " please remove them and retry");
                report.setStatus(CreateResourceStatus.FAILURE);
                return report;
            }
        }
        ResourceType resourceType = report.getResourceType();
        String attribute = attributeMap.get(resourceType.getName());
        String newChild = newChildTypeMap.get(attribute);
        Configuration configuration = report.getResourceConfiguration();
        if (attribute != null) {
            Value loaded = this.loadCodeFlagType(configuration, attribute, null);
            ArrayList<Value> newAttributeState = new ArrayList<Value>();
            newAttributeState.add(loaded);
            Address newChildLocation = new Address(this.path + "," + newChild);
            Operation op = ModuleOptionsComponent.createAddModuleOptionTypeOperation(newChildLocation, attribute, newAttributeState);
            Result result = connection.execute(op);
            if (result.isSuccess()) {
                report.setStatus(CreateResourceStatus.SUCCESS);
                report.setResourceKey(newChildLocation.getPath());
                report.setResourceName(report.getResourceType().getName());
            } else {
                report.setStatus(CreateResourceStatus.FAILURE);
                report.setErrorMessage(result.getFailureDescription());
            }
        } else {
            ResourceType parentType = (ResourceType)resourceType.getParentResourceTypes().toArray()[0];
            attribute = attributeMap.get(parentType.getName());
            ReadAttribute op = new ReadAttribute(this.address, attribute);
            Result result = this.getASConnection().execute(op);
            if (result.isSuccess()) {
                List<Object> currentAttributeState = new ArrayList();
                currentAttributeState = ModuleOptionsComponent.populateSecurityDomainModuleOptions(result, ModuleOptionsComponent.loadModuleOptionType(attribute));
                Value loaded = this.loadCodeFlagType(configuration, attribute, null);
                currentAttributeState.add(loaded);
                WriteAttribute write = new WriteAttribute(this.address);
                write.addAdditionalProperty("name", attribute);
                write.addAdditionalProperty("value", currentAttributeState);
                result = connection.execute(write);
                if (result.isSuccess()) {
                    report.setStatus(CreateResourceStatus.SUCCESS);
                    report.setResourceKey(this.path + "," + attribute + ":" + (currentAttributeState.size() - 1));
                    report.setResourceName(ModuleOptionType.readableNameMap.get(attribute) + " " + (currentAttributeState.size() - 1));
                } else {
                    report.setStatus(CreateResourceStatus.FAILURE);
                    report.setErrorMessage(result.getFailureDescription());
                }
            }
        }
        return report;
    }

    @Override
    public Configuration loadResourceConfiguration() throws Exception {
        Configuration configuration = new Configuration();
        ResourceType resourceType = this.context.getResourceType();
        Set nodeParentTypes = this.context.getResourceType().getParentResourceTypes();
        ResourceType parentType = (ResourceType)nodeParentTypes.toArray()[0];
        ResourceType grandParentType = (ResourceType)parentType.getParentResourceTypes().toArray()[0];
        if (this.isSupportedModuleOptionTypeOrImmediateChildOf(parentType, resourceType)) {
            boolean currentNodeIsModuleType = false;
            if (attributeMap.get(resourceType.getName()) != null) {
                currentNodeIsModuleType = true;
            }
            String attribute = attributeMap.get(parentType.getName());
            if (currentNodeIsModuleType) {
                attribute = attributeMap.get(resourceType.getName());
            }
            ReadAttribute op = new ReadAttribute(this.address, attribute);
            Result result = this.getASConnection().execute(op);
            if (result.isSuccess()) {
                List<Object> currentAttributeState = new ArrayList();
                currentAttributeState = ModuleOptionsComponent.populateSecurityDomainModuleOptions(result, ModuleOptionsComponent.loadModuleOptionType(attribute));
                if (currentNodeIsModuleType) {
                    Value loaded = (Value)currentAttributeState.get(0);
                    this.populateCodeFlagType(configuration, attribute, loaded);
                } else {
                    String moduleTypeIdentifier = attribute + ":";
                    int index = this.path.indexOf(moduleTypeIdentifier);
                    String loginModuleIndex = this.path.substring(index + moduleTypeIdentifier.length());
                    int lmi = Integer.valueOf(loginModuleIndex);
                    if (currentAttributeState.size() > lmi) {
                        Value loaded = (Value)currentAttributeState.get(lmi);
                        this.populateCodeFlagType(configuration, attribute, loaded);
                    }
                }
            }
            return configuration;
        }
        if (this.supportsLoginModuleOptionType(grandParentType)) {
            String attribute = attributeMap.get(grandParentType.getName());
            ReadAttribute op = new ReadAttribute(this.address, attribute);
            Result result = this.getASConnection().execute(op);
            if (result.isSuccess()) {
                List<Object> currentAttributeState = new ArrayList();
                currentAttributeState = ModuleOptionsComponent.populateSecurityDomainModuleOptions(result, ModuleOptionsComponent.loadModuleOptionType(attribute));
                String moduleTypeIdentifier = attribute + ":";
                int index = this.path.indexOf(moduleTypeIdentifier);
                String loginModuleIndex = this.path.substring(index + moduleTypeIdentifier.length());
                String[] split = loginModuleIndex.split(",");
                int lmi = Integer.valueOf(split[0]);
                if (lmi < currentAttributeState.size()) {
                    Value loaded = (Value)currentAttributeState.get(lmi);
                    LinkedHashMap<String, Object> currentModuleOptions = loaded.getOptions();
                    String id = "Module Options";
                    PropertyMap map = new PropertyMap(id);
                    for (String key : currentModuleOptions.keySet()) {
                        PropertySimple option = new PropertySimple(key, currentModuleOptions.get(key));
                        map.put((Property)option);
                    }
                    if (!currentModuleOptions.isEmpty()) {
                        configuration.put((Property)map);
                    }
                }
            }
            return configuration;
        }
        ConfigurationDefinition configDef = this.context.getResourceType().getResourceConfigurationDefinition();
        ConfigurationLoadDelegate delegate = new ConfigurationLoadDelegate(configDef, this.getASConnection(), this.address, this.includeRuntime);
        configuration = delegate.loadResourceConfiguration();
        ReadAttribute op = new ReadAttribute(this.getAddress(), "name");
        this.executeAndGenerateServerUpdateIfNecessary(configuration, op);
        return configuration;
    }

    private boolean supportsLoginModuleOptionType(ResourceType grandParentType) {
        boolean supportModuleOptionTypes = false;
        if (grandParentType != null) {
            for (String moduleOptionType : supportedModuleOptionTypeNodes) {
                if (grandParentType.getName().indexOf(moduleOptionType) <= -1) continue;
                supportModuleOptionTypes = true;
            }
        }
        return supportModuleOptionTypes;
    }

    private boolean isSupportedModuleOptionTypeOrImmediateChildOf(ResourceType parentType, ResourceType resourceType) {
        boolean loadThisConfiguration = false;
        if (parentType != null && resourceType != null) {
            for (String moduleOptionType : attributeMap.keySet()) {
                if (!parentType.getName().equals(moduleOptionType) && !resourceType.getName().equals(moduleOptionType)) continue;
                loadThisConfiguration = true;
            }
        }
        return loadThisConfiguration;
    }

    private void populateCodeFlagType(Configuration configuration, String attribute, Value loaded) {
        if (attribute.equals(providerModules)) {
            PropertySimple currentValue = new PropertySimple("code", (Object)loaded.getCode());
            configuration.put((Property)currentValue);
        } else if (attribute.equals(mappingModules)) {
            PropertySimple currentValue = new PropertySimple("code", (Object)loaded.getCode());
            PropertySimple currentValue2 = new PropertySimple("type", (Object)loaded.getType());
            configuration.put((Property)currentValue);
            configuration.put((Property)currentValue2);
        } else {
            PropertySimple currentValue = new PropertySimple("code", (Object)loaded.getCode());
            PropertySimple currentValue2 = new PropertySimple("flag", (Object)loaded.getFlag());
            configuration.put((Property)currentValue);
            configuration.put((Property)currentValue2);
        }
    }

    private Value loadCodeFlagType(Configuration configuration, String attribute, Value loaded) {
        if (configuration == null || attribute == null) {
            return null;
        }
        if (loaded == null) {
            loaded = new Value();
        }
        if (attribute.equals(providerModules)) {
            String code = configuration.getSimpleValue("code");
            loaded.setCode(code);
        } else if (attribute.equals(mappingModules)) {
            String code = configuration.getSimpleValue("code");
            String type = configuration.getSimpleValue("type");
            loaded.setCode(code);
            loaded.setType(type);
        } else {
            String code = configuration.getSimpleValue("code");
            String flag = configuration.getSimpleValue("flag");
            loaded.setCode(code);
            loaded.setFlag(flag);
        }
        return loaded;
    }

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        ResourceType resourceType = this.context.getResourceType();
        ConfigurationDefinition configDef = this.context.getResourceType().getResourceConfigurationDefinition();
        Set nodeParentTypes = this.context.getResourceType().getParentResourceTypes();
        ResourceType parentType = (ResourceType)nodeParentTypes.toArray()[0];
        ResourceType grandParentType = (ResourceType)parentType.getParentResourceTypes().toArray()[0];
        if (this.isSupportedModuleOptionTypeOrImmediateChildOf(parentType, resourceType)) {
            boolean currentNodeIsModuleType = false;
            if (attributeMap.get(resourceType.getName()) != null) {
                currentNodeIsModuleType = true;
            }
            String attribute = attributeMap.get(parentType.getName());
            if (currentNodeIsModuleType) {
                attribute = attributeMap.get(resourceType.getName());
            }
            ReadAttribute op = new ReadAttribute(this.address, attribute);
            Result result = this.getASConnection().execute(op);
            if (result.isSuccess()) {
                List entries = (List)result.getResult();
                List<Object> currentAttributeState = new ArrayList();
                currentAttributeState = ModuleOptionsComponent.populateSecurityDomainModuleOptions(result, ModuleOptionsComponent.loadModuleOptionType(attribute));
                Configuration conf = report.getConfiguration();
                if (currentNodeIsModuleType) {
                    Value loaded = (Value)currentAttributeState.get(0);
                    for (String pKey : conf.getSimpleProperties().keySet()) {
                        if (pKey.equals("flag")) {
                            loaded.setFlag(((PropertySimple)conf.getSimpleProperties().get(pKey)).getStringValue());
                            continue;
                        }
                        if (pKey.equals("code")) {
                            loaded.setCode(((PropertySimple)conf.getSimpleProperties().get(pKey)).getStringValue());
                            continue;
                        }
                        if (!pKey.equals("type")) continue;
                        loaded.setType(((PropertySimple)conf.getSimpleProperties().get(pKey)).getStringValue());
                    }
                    WriteAttribute write = new WriteAttribute(this.address);
                    write.addAdditionalProperty("name", attribute);
                    write.addAdditionalProperty("value", currentAttributeState);
                    this.executeWriteAndGenerateAs7ServerUpdate(report, conf, write);
                } else {
                    String loginModuleIdentifier = attribute + ":";
                    int index = this.path.indexOf(loginModuleIdentifier);
                    String loginModuleIndex = this.path.substring(index + loginModuleIdentifier.length());
                    int lmi = Integer.valueOf(loginModuleIndex);
                    Value valueObject = (Value)currentAttributeState.get(lmi);
                    for (String pKey : conf.getSimpleProperties().keySet()) {
                        if (pKey.equals("flag")) {
                            valueObject.setFlag(((PropertySimple)conf.getSimpleProperties().get(pKey)).getStringValue());
                            continue;
                        }
                        if (pKey.equals("code")) {
                            valueObject.setCode(((PropertySimple)conf.getSimpleProperties().get(pKey)).getStringValue());
                            continue;
                        }
                        if (!pKey.equals("type")) continue;
                        valueObject.setType(((PropertySimple)conf.getSimpleProperties().get(pKey)).getStringValue());
                    }
                    WriteAttribute write = new WriteAttribute(this.address);
                    write.addAdditionalProperty("name", attribute);
                    write.addAdditionalProperty("value", currentAttributeState);
                    this.executeWriteAndGenerateAs7ServerUpdate(report, conf, write);
                }
            }
        } else if (this.supportsLoginModuleOptionType(grandParentType)) {
            String attribute = attributeMap.get(grandParentType.getName());
            ReadAttribute op = new ReadAttribute(this.address, attribute);
            Result result = this.getASConnection().execute(op);
            if (result.isSuccess()) {
                List<Object> currentAttributeState = new ArrayList();
                currentAttributeState = ModuleOptionsComponent.populateSecurityDomainModuleOptions(result, ModuleOptionsComponent.loadModuleOptionType(attribute));
                String loginModuleIdentifier = attribute + ":";
                int index = this.path.indexOf(loginModuleIdentifier);
                String loginModuleIndex = this.path.substring(index + loginModuleIdentifier.length());
                String[] split = loginModuleIndex.split(",");
                int lmi = Integer.valueOf(split[0]);
                Value valueObject = (Value)currentAttributeState.get(lmi);
                Configuration conf = report.getConfiguration();
                String mapKey = (String)conf.getMap().keySet().toArray()[0];
                PropertyMap mapType = (PropertyMap)conf.getMap().get(mapKey);
                LinkedHashMap<String, Object> currentOptions = new LinkedHashMap<String, Object>();
                for (String propertyKey : mapType.getMap().keySet()) {
                    currentOptions.put(propertyKey, ((PropertySimple)mapType.get(propertyKey)).getStringValue());
                }
                valueObject.setOptions(currentOptions);
                currentAttributeState.set(lmi, valueObject);
                WriteAttribute write = new WriteAttribute(this.address);
                write.addAdditionalProperty("name", attribute);
                write.addAdditionalProperty("value", currentAttributeState);
                this.executeWriteAndGenerateAs7ServerUpdate(report, conf, write);
            }
        } else {
            ConfigurationWriteDelegate delegate = new ConfigurationWriteDelegate(configDef, this.getASConnection(), this.address);
            delegate.updateResourceConfiguration(report);
        }
    }

    private void executeWriteAndGenerateAs7ServerUpdate(ConfigurationUpdateReport report, Configuration conf, Operation write) {
        Result result = this.getASConnection().execute(write);
        if (!result.isSuccess()) {
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessage(result.getFailureDescription());
        } else {
            PropertySimple oobMessage;
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
            if (result.isReloadRequired()) {
                oobMessage = new PropertySimple("__OOB", (Object)"The server needs a reload for the latest changes to come effective.");
                conf.put((Property)oobMessage);
            }
            if (result.isRestartRequired()) {
                oobMessage = new PropertySimple("__OOB", (Object)"The server needs a restart for the latest changes to come effective.");
                conf.put((Property)oobMessage);
            }
        }
    }

    private void executeAndGenerateServerUpdateIfNecessary(Configuration configuration, ReadAttribute op) {
        PropertySimple oobMessage;
        Result res = this.getASConnection().execute(op);
        if (res.isReloadRequired()) {
            oobMessage = new PropertySimple("__OOB", (Object)"The server needs a reload for the latest changes to come effective.");
            configuration.put((Property)oobMessage);
        }
        if (res.isRestartRequired()) {
            oobMessage = new PropertySimple("__OOB", (Object)"The server needs a restart for the latest changes to come effective.");
            configuration.put((Property)oobMessage);
        }
    }

    public static ModuleOptionType loadModuleOptionType(String attribute) {
        ModuleOptionType located = ModuleOptionType.typeMap.get(attribute);
        if (located == null) {
            throw new IllegalArgumentException("Unknown node '" + attribute + "' entered for which no valid ModuleOptionType could be found.");
        }
        return located;
    }

    public static List<Value> populateSecurityDomainModuleOptions(Result result, ModuleOptionType type) {
        Object rawResult;
        ArrayList<Value> populated = new ArrayList<Value>();
        if (result != null && result.isSuccess() && (rawResult = result.getResult()) instanceof ArrayList) {
            ArrayList moduleOptionTypeChildrenList = (ArrayList)rawResult;
            for (int i = 0; i < moduleOptionTypeChildrenList.size(); ++i) {
                Value value = new Value();
                LinkedHashMap<String, Object> optionsMap = new LinkedHashMap<String, Object>();
                Object entryCheck = ((ArrayList)rawResult).get(i);
                if (entryCheck instanceof HashMap) {
                    HashMap attributeMap = (HashMap)entryCheck;
                    for (String key : attributeMap.keySet()) {
                        Object listEntryCheck;
                        String extracted = String.valueOf(attributeMap.get(key));
                        if (extracted.trim().isEmpty()) continue;
                        if (key.equals("flag")) {
                            value.setFlag(extracted);
                            continue;
                        }
                        if (key.equals("code")) {
                            value.setCode(extracted);
                            continue;
                        }
                        if (key.equals("type")) {
                            value.setType(extracted);
                            continue;
                        }
                        if (!key.equals("module-options")) continue;
                        Object optionEntity = attributeMap.get(key);
                        if (optionEntity instanceof HashMap) {
                            HashMap entryList = (HashMap)optionEntity;
                            for (String oKey : entryList.keySet()) {
                                optionsMap.put(oKey, String.valueOf(entryList.get(oKey)));
                            }
                            continue;
                        }
                        if (!(optionEntity instanceof ArrayList) || !((listEntryCheck = ((ArrayList)optionEntity).get(0)) instanceof HashMap)) continue;
                        ArrayList list = (ArrayList)optionEntity;
                        for (Object listEntry : list) {
                            HashMap entryList = (HashMap)listEntry;
                            for (String oKey : entryList.keySet()) {
                                optionsMap.put(oKey, String.valueOf(entryList.get(oKey)));
                            }
                        }
                    }
                }
                value.setOptions(optionsMap);
                populated.add(value);
            }
        }
        return populated;
    }

    public static Operation createAddModuleOptionTypeOperation(Address address, String attribute, List<Value> moduleTypeValue) {
        Operation add = null;
        if (address != null & attribute != null & moduleTypeValue != null) {
            add = new Operation("add", address);
            add.addAdditionalProperty(attribute, moduleTypeValue);
        }
        return add;
    }

    static {
        attributeMap.put(AUTH_CLASSIC_NODE + ")", loginModules);
        attributeMap.put(AUTH_CLASSIC_NODE + " - Managed Server)", loginModules);
        attributeMap.put(AUTH_CLASSIC_NODE + " - Profile)", loginModules);
        attributeMap.put(AUTH_JASPI_NODE + ")", authModules);
        attributeMap.put(AUTH_JASPI_NODE + " - Managed Server)", authModules);
        attributeMap.put(AUTH_JASPI_NODE + " - Profile)", authModules);
        attributeMap.put(ACL_NODE, aclModules);
        attributeMap.put(ACL_NODE + " (Managed Server)", aclModules);
        attributeMap.put(ACL_NODE + " (Profile)", aclModules);
        attributeMap.put(AUDIT_NODE, providerModules);
        attributeMap.put(AUDIT_NODE + " (Managed Server)", providerModules);
        attributeMap.put(AUDIT_NODE + " (Profile)", providerModules);
        attributeMap.put(AUTHORIZATION_NODE, policyModules);
        attributeMap.put(AUTHORIZATION_NODE + " (Managed Server)", policyModules);
        attributeMap.put(AUTHORIZATION_NODE + " (Profile)", policyModules);
        attributeMap.put(TRUST_NODE, trustModules);
        attributeMap.put(TRUST_NODE + " (Managed Server)", trustModules);
        attributeMap.put(TRUST_NODE + " (Profile)", trustModules);
        attributeMap.put(MAPPING_NODE, mappingModules);
        attributeMap.put(MAPPING_NODE + " (Managed Server)", mappingModules);
        attributeMap.put(MAPPING_NODE + " (Profile)", mappingModules);
        newChildTypeMap = new HashMap();
        newChildTypeMap.put(loginModules, "authentication=classic");
        newChildTypeMap.put(authModules, "authentication=jaspi");
        newChildTypeMap.put(aclModules, "acl=classic");
        newChildTypeMap.put(providerModules, "audit=classic");
        newChildTypeMap.put(policyModules, "authorization=classic");
        newChildTypeMap.put(trustModules, "identity-trust=classic");
        newChildTypeMap.put(mappingModules, "mapping=classic");
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static class Value {
        @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
        private String flag;
        private String code;
        @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
        private String type;
        @JsonProperty(value="module-options")
        @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
        private LinkedHashMap<String, Object> options = null;

        public Value() {
        }

        public Value(String code, String flag, String type) {
            this.setCode(code);
            if (flag != null && !flag.trim().isEmpty()) {
                this.setFlag(flag);
            }
            if (type != null && !type.trim().isEmpty()) {
                this.setType(type);
            }
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getFlag() {
            return this.flag;
        }

        public void setFlag(String flag) {
            this.flag = flag;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        @JsonProperty(value="module-options")
        public LinkedHashMap<String, Object> getOptions() {
            if (this.options == null) {
                this.options = new LinkedHashMap();
            }
            return this.options;
        }

        @JsonProperty(value="module-options")
        public void setOptions(LinkedHashMap<String, Object> options) {
            this.options = options;
        }

        public String toString() {
            String serialized = "";
            serialized = serialized + "code=" + this.getCode() + ", ";
            if (this.getFlag() != null) {
                serialized = serialized + "flag=" + this.getFlag() + ", ";
            } else if (this.getType() != null) {
                serialized = serialized + "type=" + this.getType() + ", ";
            }
            String options = "module-options=";
            if (this.getOptions().isEmpty()) {
                options = options + " {}";
            } else {
                options = options + " {";
                for (String key : this.getOptions().keySet()) {
                    options = options + key + "=\"" + this.getOptions().get(key) + "\",";
                }
                options = options.substring(0, options.length() - 1);
                options = options + "} ";
            }
            serialized = serialized + options;
            return serialized;
        }
    }

    public static enum ModuleOptionType {
        Acl(ModuleOptionsComponent.access$000()),
        Audit(ModuleOptionsComponent.access$100()),
        Authentication(ModuleOptionsComponent.access$200()),
        AuthenticationJaspi(ModuleOptionsComponent.access$300()),
        Authorization(ModuleOptionsComponent.access$400()),
        IdentityTrust(ModuleOptionsComponent.access$500()),
        Mapping(ModuleOptionsComponent.access$600());

        private String attribute = "";
        public static HashMap<String, ModuleOptionType> typeMap;
        public static Map<String, String> readableNameMap;

        public String getAttribute() {
            return this.attribute;
        }

        private ModuleOptionType(String attribute) {
            this.attribute = attribute;
        }

        static {
            typeMap = new HashMap();
            for (ModuleOptionType type : ModuleOptionType.values()) {
                typeMap.put(type.getAttribute(), type);
            }
            readableNameMap = new HashMap<String, String>();
            readableNameMap.put(aclModules, "ACL Modules");
            readableNameMap.put(providerModules, "Provider Modules");
            readableNameMap.put(loginModules, "Login Modules");
            readableNameMap.put(authModules, "Auth Modules");
            readableNameMap.put(policyModules, "Policy Modules");
            readableNameMap.put(trustModules, "Trust Modules");
            readableNameMap.put(mappingModules, "Mapping Modules");
        }
    }
}

