/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeFacet;
import org.rhq.modules.plugins.jbossas7.AbstractVersionedSubsystemDiscovery;
import org.rhq.modules.plugins.jbossas7.BaseComponent;

public class VersionedSubsystemDiscovery
extends AbstractVersionedSubsystemDiscovery
implements ResourceUpgradeFacet {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<BaseComponent<?>> context) throws Exception {
        Set<DiscoveredResourceDetails> details = super.discoverResources(context);
        if (DISABLED || null == details || details.isEmpty()) {
            return details;
        }
        ArrayList<DiscoveredResourceDetails> updatedDetails = new ArrayList<DiscoveredResourceDetails>(details);
        HashMap<String, Integer> keyCount = new HashMap<String, Integer>(updatedDetails.size());
        details.clear();
        for (DiscoveredResourceDetails discoveredResourceDetails : updatedDetails) {
            int n;
            MATCHER.reset(discoveredResourceDetails.getResourceName());
            if (MATCHER.matches()) {
                discoveredResourceDetails.setResourceName(MATCHER.group(1) + MATCHER.group(3));
                if ("Subdeployment".equals(context.getResourceType().getName())) {
                    String parentResourceVersion = context.getParentResourceContext().getVersion();
                    parentResourceVersion = null == parentResourceVersion ? "" : parentResourceVersion + "/";
                    discoveredResourceDetails.setResourceVersion(parentResourceVersion + MATCHER.group(2));
                } else {
                    discoveredResourceDetails.setResourceVersion(MATCHER.group(2));
                }
            }
            StringBuilder sb = new StringBuilder();
            String comma = "";
            for (String segment : discoveredResourceDetails.getResourceKey().split(",")) {
                sb.append(comma);
                comma = ",";
                MATCHER.reset(segment);
                if (MATCHER.matches()) {
                    sb.append(MATCHER.group(1) + MATCHER.group(3));
                    continue;
                }
                sb.append(segment);
            }
            discoveredResourceDetails.setResourceKey(sb.toString());
            Integer count = (Integer)keyCount.get(discoveredResourceDetails.getResourceKey());
            String string = discoveredResourceDetails.getResourceKey();
            if (null == count) {
                n = 1;
            } else {
                count = count + 1;
                n = count;
            }
            keyCount.put(string, n);
        }
        for (Map.Entry entry : keyCount.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            this.log.warn((Object)("Discovered multiple resources with resource key [" + (String)entry.getKey() + "].  This is not allowed and they will be removed from discovery.  This is typically caused by " + "having multiple versions of the same Deployment deployed.  To solve the problem either remove " + "all but one version of the problem deployment or disable versioned deployment handling by " + "setting -Drhq.as7.VersionedSubsystemDiscovery.pattern=disable for the agent."));
            Iterator<DiscoveredResourceDetails> i = updatedDetails.iterator();
            while (i.hasNext()) {
                DiscoveredResourceDetails detail = i.next();
                if (!detail.getResourceKey().equals(entry.getKey())) continue;
                i.remove();
            }
        }
        details.addAll(updatedDetails);
        return details;
    }

    public ResourceUpgradeReport upgrade(ResourceUpgradeContext inventoriedResource) {
        ResourceUpgradeReport result = null;
        if (DISABLED) {
            return result;
        }
        MATCHER.reset(inventoriedResource.getName());
        if (MATCHER.matches()) {
            result = new ResourceUpgradeReport();
            result.setForceGenericPropertyUpgrade(true);
            result.setNewName(MATCHER.group(1) + MATCHER.group(3));
            if ("Subdeployment".equals(inventoriedResource.getResourceType().getName())) {
                String parentResourceVersion = inventoriedResource.getParentResourceContext().getVersion();
                parentResourceVersion = null == parentResourceVersion ? "" : parentResourceVersion + "/";
                result.setNewVersion(parentResourceVersion + MATCHER.group(2));
            } else {
                result.setNewVersion(MATCHER.group(2));
            }
        }
        StringBuilder sb = new StringBuilder();
        String comma = "";
        boolean upgradeKey = false;
        for (String segment : inventoriedResource.getResourceKey().split(",")) {
            sb.append(comma);
            comma = ",";
            MATCHER.reset(segment);
            if (MATCHER.matches()) {
                upgradeKey = true;
                sb.append(MATCHER.group(1) + MATCHER.group(3));
                continue;
            }
            sb.append(segment);
        }
        if (upgradeKey) {
            if (null == result) {
                result = new ResourceUpgradeReport();
            }
            result.setNewResourceKey(sb.toString());
        }
        if (null != result && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Requesting upgrade: " + result));
        }
        return result;
    }
}

