/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class JdrReportRunner {
    final Log log = LogFactory.getLog(JdrReportRunner.class);
    private final Address path;
    private final ASConnection connection;

    public JdrReportRunner(Address path, ASConnection con) {
        this.path = new Address(path);
        this.connection = con;
        this.path.addSegment("subsystem=jdr");
    }

    public InputStream getReport() throws Exception {
        this.log.info((Object)("Obtaining JDR Report form " + this.path));
        Operation operation = new Operation("generate-jdr-report", this.path);
        Result res = this.connection.execute(operation, false, 120);
        if (res.isSuccess()) {
            Map map = (Map)res.getResult();
            File report = new File(map.get("report-location").toString());
            if (report.exists() && report.canRead()) {
                this.log.info((Object)("JDR Report created in " + report.getAbsolutePath()));
                return new FileInputStream(report);
            }
            throw new IOException("Failed to read generated JDR Report file " + report.getAbsolutePath());
        }
        this.log.error((Object)("Failed to generate JDR Report : " + res.getFailureDescription()));
        return null;
    }
}

