/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.sasl.util.UsernamePasswordHashUtil;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.util.ProcessExecutionUtility;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.rhq.modules.plugins.jbossas7.AbstractBaseDiscovery;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class BaseServerComponent
extends BaseComponent
implements MeasurementFacet {
    private static final String SEPARATOR = "\n-----------------------\n";
    final Log log = LogFactory.getLog(BaseServerComponent.class);

    protected OperationResult restartServer(Configuration parameters, AS7Mode mode) throws Exception {
        OperationResult tmp = this.invokeOperation("shutdown", parameters);
        if (tmp.getErrorMessage() != null) {
            tmp.setErrorMessage("Restart failed while failing to shut down: " + tmp.getErrorMessage());
            return tmp;
        }
        Thread.sleep(500L);
        return this.startServer(mode);
    }

    protected OperationResult startServer(AS7Mode mode) {
        OperationResult operationResult = new OperationResult();
        String startScript = this.pluginConfiguration.getSimpleValue("startScript", mode.getStartScript());
        String baseDir = this.pluginConfiguration.getSimpleValue("baseDir", "");
        if (baseDir.isEmpty()) {
            operationResult.setErrorMessage("No base directory provided");
            return operationResult;
        }
        String script = baseDir + File.separator + startScript;
        ProcessExecution processExecution = ProcessExecutionUtility.createProcessExecution((File)new File(script));
        String config = this.pluginConfiguration.getSimpleValue(mode.getConfigPropertyName(), mode.getDefaultXmlFile());
        ArrayList<String> arguments = processExecution.getArguments();
        if (arguments == null) {
            arguments = new ArrayList<String>();
            processExecution.setArguments(arguments);
        }
        if (!config.equals(mode.getDefaultXmlFile())) {
            arguments.add(mode.getConfigArg());
            arguments.add(config);
        }
        if (mode == AS7Mode.DOMAIN && !(config = this.pluginConfiguration.getSimpleValue(AS7Mode.HOST.getConfigPropertyName(), AS7Mode.HOST.getDefaultXmlFile())).equals(AS7Mode.HOST.getDefaultXmlFile())) {
            arguments.add(AS7Mode.HOST.getConfigArg());
            arguments.add(config);
        }
        processExecution.setWorkingDirectory(baseDir);
        processExecution.setCaptureOutput(true);
        processExecution.setWaitForCompletion(15000L);
        processExecution.setKillOnTimeout(false);
        String javaHomeDir = this.pluginConfiguration.getSimpleValue("javaHomePath", null);
        if (javaHomeDir != null) {
            processExecution.getEnvironmentVariables().put("JAVA_HOME", javaHomeDir);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("About to execute the following process: [" + processExecution + "]"));
        }
        ProcessExecutionResults results = this.context.getSystemInformation().executeProcess(processExecution);
        this.logExecutionResults(results);
        if (results.getError() != null) {
            operationResult.setErrorMessage(results.getError().getMessage());
        } else if (results.getExitCode() != null) {
            operationResult.setErrorMessage("Start failed with error code " + results.getExitCode() + ":\n" + results.getCapturedOutput());
        } else {
            operationResult.setSimpleResult("Success");
        }
        return operationResult;
    }

    private void logExecutionResults(ProcessExecutionResults results) {
        this.log.info((Object)("Exit code from process execution: " + results.getExitCode()));
        this.log.info((Object)("Output from process execution: \n-----------------------\n" + results.getCapturedOutput() + SEPARATOR));
    }

    protected OperationResult postProcessResult(String name, Result res) {
        OperationResult operationResult = new OperationResult();
        if (res == null) {
            operationResult.setErrorMessage("No result received from server");
            return operationResult;
        }
        if (name.equals("shutdown") || name.equals("reload")) {
            if (!res.isSuccess()) {
                if (res.getRhqThrowable() != null && (res.getRhqThrowable() instanceof ConnectException || res.getRhqThrowable().getMessage().equals("Connection refused"))) {
                    operationResult.setSimpleResult("Success");
                    this.log.debug((Object)("Got a ConnectionRefused for operation " + name + " this is considered ok, as the remote server sometimes closes the communications channel before sending a reply"));
                } else {
                    operationResult.setErrorMessage(res.getFailureDescription());
                }
            } else {
                operationResult.setSimpleResult("Success");
            }
        } else if (res.isSuccess()) {
            if (res.getResult() != null) {
                operationResult.setSimpleResult(res.getResult().toString());
            } else {
                operationResult.setSimpleResult("-None provided by server-");
            }
        } else {
            operationResult.setErrorMessage(res.getFailureDescription());
        }
        return operationResult;
    }

    protected OperationResult installManagementUser(Configuration parameters, Configuration pluginConfig, AS7Mode mode) {
        String user = parameters.getSimpleValue("user", "");
        String password = parameters.getSimpleValue("password", "");
        OperationResult result = new OperationResult();
        PropertySimple remoteProp = pluginConfig.getSimple("manuallyAdded");
        if (remoteProp != null && remoteProp.getBooleanValue() != null && remoteProp.getBooleanValue().booleanValue()) {
            result.setErrorMessage("This is a manually added server. This operation can not be used to install a management used. Use the server's 'bin/add-user.sh'");
            return result;
        }
        if (user.isEmpty() || password.isEmpty()) {
            result.setErrorMessage("User and Password must not be empty");
            return result;
        }
        String baseDir = pluginConfig.getSimpleValue("baseDir", "");
        if (baseDir.isEmpty()) {
            result.setErrorMessage("No baseDir found, can not continue");
            return result;
        }
        String standaloneXmlFile = pluginConfig.getSimpleValue("config", mode.getDefaultXmlFile());
        String standaloneXml = baseDir + File.separator + mode.getBaseDir() + File.separator + "configuration" + File.separator + standaloneXmlFile;
        AbstractBaseDiscovery abd = new AbstractBaseDiscovery();
        abd.readStandaloneOrHostXmlFromFile(standaloneXml);
        String realm = pluginConfig.getSimpleValue("realm", "ManagementRealm");
        String propertiesFilePath = abd.getSecurityPropertyFileFromHostXml(baseDir, mode, realm);
        Properties p = new Properties();
        try {
            UsernamePasswordHashUtil util = new UsernamePasswordHashUtil();
            String value = util.generateHashedHexURP(user, realm, password.toCharArray());
            FileInputStream fis = new FileInputStream(propertiesFilePath);
            p.load(fis);
            fis.close();
            p.setProperty(user, value);
            FileOutputStream fos = new FileOutputStream(propertiesFilePath);
            p.store(fos, null);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage());
            result.setErrorMessage(e.getMessage());
        }
        catch (NoSuchAlgorithmException nsae) {
            this.log.error((Object)nsae.getMessage());
            result.setErrorMessage(nsae.getMessage());
        }
        result.setSimpleResult("User/Password set or updated");
        return result;
    }

    public void getValues(MeasurementReport report, Set metrics) throws Exception {
        Set requests = metrics;
        HashSet<MeasurementScheduleRequest> leftovers = new HashSet<MeasurementScheduleRequest>(requests.size());
        for (MeasurementScheduleRequest request : requests) {
            if (request.getName().equals("startTime")) {
                String path = this.getPath();
                if (this.context.getResourceType().getName().contains("Host Controller")) {
                    path = path != null ? "host=master," + path : "host=master";
                }
                Address address = new Address(path);
                address.add("core-service", "platform-mbean");
                address.add("type", "runtime");
                ReadAttribute op = new ReadAttribute(address, "start-time");
                Result res = this.getASConnection().execute(op);
                if (!res.isSuccess()) continue;
                Long startTime = (Long)res.getResult();
                MeasurementDataTrait data = new MeasurementDataTrait(request, new Date(startTime).toString());
                report.addData(data);
                continue;
            }
            leftovers.add(request);
        }
        super.getValues(report, leftovers);
    }
}

