/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.ASUploadConnection;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.PROPERTY_VALUE;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.ReadChildrenResources;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class DeploymentComponent
extends BaseComponent
implements OperationFacet,
ContentFacet {
    private boolean verbose = ASConnection.verbose;

    @Override
    public AvailabilityType getAvailability() {
        ReadAttribute op = new ReadAttribute(this.getAddress(), "enabled");
        Result res = this.getASConnection().execute(op);
        if (!res.isSuccess()) {
            return AvailabilityType.DOWN;
        }
        if (res.getResult() == null || !((Boolean)res.getResult()).booleanValue()) {
            return AvailabilityType.DOWN;
        }
        return AvailabilityType.UP;
    }

    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        String action;
        if (name.equals("enable")) {
            action = "deploy";
        } else if (name.equals("disable")) {
            action = "undeploy";
        } else {
            return super.invokeOperation(name, parameters);
        }
        Operation op = new Operation(action, this.getAddress());
        Result res = this.getASConnection().execute(op);
        OperationResult result = new OperationResult();
        if (res.isSuccess()) {
            result.setSimpleResult("Success");
        } else {
            result.setErrorMessage(res.getFailureDescription());
        }
        return result;
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails packageDetails) {
        return new ArrayList<DeployPackageStep>();
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        this.log.info((Object)"Starting deployment..");
        DeployPackagesResponse response = new DeployPackagesResponse();
        if (packages.size() != 1) {
            response.setOverallRequestResult(ContentResponseResult.FAILURE);
            response.setOverallRequestErrorMessage("Can only deploy one package at a time");
            this.log.warn((Object)"deployPackages can only deploy one package at a time");
        }
        ResourcePackageDetails detail = packages.iterator().next();
        ASUploadConnection uploadConnection = new ASUploadConnection(this.getASConnection());
        OutputStream out = uploadConnection.getOutputStream(detail.getFileName());
        ResourceType resourceType = this.context.getResourceType();
        this.log.info((Object)("trying deployment of" + resourceType.getName() + ", key=" + detail.getKey()));
        contentServices.downloadPackageBits(this.context.getContentContext(), detail.getKey(), out, true);
        JsonNode uploadResult = uploadConnection.finishUpload();
        if (this.verbose) {
            this.log.info((Object)uploadResult);
        }
        if (ASUploadConnection.isErrorReply(uploadResult)) {
            response.setOverallRequestResult(ContentResponseResult.FAILURE);
            response.setOverallRequestErrorMessage(ASUploadConnection.getFailureDescription(uploadResult));
            return response;
        }
        JsonNode resultNode = uploadResult.get("result");
        String hash = resultNode.get("BYTES_VALUE").getTextValue();
        CreateResourceReport report1 = new CreateResourceReport("", resourceType, new Configuration(), new Configuration(), detail);
        try {
            this.redeployOnServer(detail.getKey().getName(), hash);
            response.setOverallRequestResult(ContentResponseResult.SUCCESS);
            DeployIndividualPackageResponse packageResponse = new DeployIndividualPackageResponse(detail.getKey(), ContentResponseResult.SUCCESS);
            response.addPackageResponse(packageResponse);
        }
        catch (Exception e) {
            response.setOverallRequestResult(ContentResponseResult.FAILURE);
        }
        this.log.info((Object)(".. result is " + response));
        return response;
    }

    private void redeployOnServer(String name, String hash) throws Exception {
        Operation op = new Operation("full-replace-deployment", new Address());
        op.addAdditionalProperty("name", name);
        ArrayList content = new ArrayList(1);
        HashMap<String, PROPERTY_VALUE> contentValues = new HashMap<String, PROPERTY_VALUE>();
        contentValues.put("hash", new PROPERTY_VALUE("BYTES_VALUE", hash));
        content.add(contentValues);
        op.addAdditionalProperty("content", content);
        Result result = this.getASConnection().execute(op);
        if (result.isRolledBack()) {
            throw new Exception(result.getFailureDescription());
        }
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> packages) {
        return null;
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
        HashSet<ResourcePackageDetails> details = new HashSet<ResourcePackageDetails>();
        Address address1 = this.getAddress().getParent();
        ReadChildrenResources op = new ReadChildrenResources(address1, "deployment");
        ComplexResult cres = this.getASConnection().executeComplex(op);
        if (cres == null) {
            return details;
        }
        if (!cres.isSuccess()) {
            return details;
        }
        Object deployments = cres.getResult();
        for (String key : deployments.keySet()) {
            Map deployment = (Map)deployments.get(key);
            this.log.info((Object)("Discover package [" + key + "] for type [" + type + "]"));
            List contentList = (List)deployment.get("content");
            if (contentList == null) continue;
            Map hashMap = (Map)contentList.get(0);
            Map bvMap = (Map)hashMap.get("hash");
            String content = (String)bvMap.get("BYTES_VALUE");
            PackageDetailsKey pdKey = new PackageDetailsKey(key, content, type.getName(), "noarch");
            ResourcePackageDetails detail = new ResourcePackageDetails(pdKey);
            detail.setSHA256(content);
            details.add(detail);
        }
        return details;
    }

    public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        return null;
    }
}

