/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.Date;
import java.util.Set;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class ManagedASComponent
extends BaseComponent {
    @Override
    public AvailabilityType getAvailability() {
        if (this.context.getResourceType().getName().equals("Managed Server")) {
            Result result;
            Address theAddress = new Address();
            String host = this.pluginConfiguration.getSimpleValue("domainHost", "local");
            theAddress.add("host", host);
            theAddress.add("server-config", this.myServerName);
            ReadAttribute getStatus = new ReadAttribute(theAddress, "status");
            try {
                result = this.connection.execute(getStatus);
            }
            catch (Exception e) {
                this.log.warn((Object)e.getMessage());
                return AvailabilityType.DOWN;
            }
            if (!result.isSuccess()) {
                return AvailabilityType.DOWN;
            }
            String msg = result.getResult().toString();
            if (msg.contains("STARTED")) {
                return AvailabilityType.UP;
            }
            return AvailabilityType.DOWN;
        }
        return super.getAvailability();
    }

    public void getValues(MeasurementReport report, Set metrics) throws Exception {
        Set requests = metrics;
        for (MeasurementScheduleRequest request : requests) {
            if (!request.getName().equals("startTime")) continue;
            String path = this.getPath();
            path = path.replace("server-config", "server");
            Address address = new Address(path);
            address.add("core-service", "platform-mbean");
            address.add("type", "runtime");
            ReadAttribute op = new ReadAttribute(address, "start-time");
            Result res = this.getASConnection().execute(op);
            if (!res.isSuccess()) continue;
            Long startTime = (Long)res.getResult();
            MeasurementDataTrait data = new MeasurementDataTrait(request, new Date(startTime).toString());
            report.addData(data);
        }
        super.getValues(report, metrics);
    }
}

