/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.ArrayList;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class ModClusterComponent
extends BaseComponent
implements OperationFacet,
ConfigurationFacet {
    static String DYNAMIC_PROVIDER = ",dynamic-load-provider=configuration";

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        Operation op = new Operation(name, this.getAddress());
        OperationResult operationResult = new OperationResult();
        Result result = null;
        String modClusterKeyMesg = "Modcluster resource keys are not in correct format.";
        modClusterKeyMesg = modClusterKeyMesg + " Should be {modcluster address}:{jvmRoute}:{virtual-host}:{context} but instead ";
        modClusterKeyMesg = modClusterKeyMesg + " was '" + this.key + "'";
        if ("list-proxies".equals(name)) {
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                ArrayList container = (ArrayList)result.getResult();
                if (container != null && !container.isEmpty()) {
                    Object type = container.get(0);
                    String values = "";
                    if (type instanceof String) {
                        for (int i = 0; i < container.size(); ++i) {
                            values = values + container.get(i) + ",";
                        }
                        values = values.substring(0, values.length() - 1);
                    } else {
                        values = container.toString();
                    }
                    operationResult.getComplexResults().put((Property)new PropertySimple("proxy-list", (Object)values));
                } else {
                    operationResult.getComplexResults().put((Property)new PropertySimple("proxy-list", (Object)""));
                }
            }
        } else if ("add-proxy".equals(name)) {
            this.addAdditionalToOp(op, parameters, "host", false);
            this.addAdditionalToOp(op, parameters, "port", false);
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                operationResult.setSimpleResult("Success");
            }
        } else if ("remove-proxy".equals(name)) {
            this.addAdditionalToOp(op, parameters, "host", false);
            this.addAdditionalToOp(op, parameters, "port", false);
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                operationResult.setSimpleResult("Success");
            }
        } else if ("disable-context".equals(name)) {
            String[] keyComponents = this.key.split(":");
            if (keyComponents.length != 4) {
                operationResult.setErrorMessage(modClusterKeyMesg);
                return operationResult;
            }
            op.addAdditionalProperty("virtualhost", keyComponents[2]);
            op.addAdditionalProperty("context", keyComponents[3]);
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                operationResult.setSimpleResult("Success");
            }
        } else if ("enable-context".equals(name)) {
            String currentAddress = this.getAddress().getPath();
            String[] keyComponents = this.key.split(":");
            if (keyComponents.length != 4) {
                operationResult.setErrorMessage(modClusterKeyMesg);
                return operationResult;
            }
            op.addAdditionalProperty("virtualhost", keyComponents[2]);
            op.addAdditionalProperty("context", keyComponents[3]);
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                operationResult.setSimpleResult("Success");
            }
        } else if ("stop-context".equals(name)) {
            String currentAddress = this.getAddress().getPath();
            String[] keyComponents = this.key.split(":");
            if (keyComponents.length != 4) {
                operationResult.setErrorMessage(modClusterKeyMesg);
                return operationResult;
            }
            op.addAdditionalProperty("virtualhost", keyComponents[2]);
            op.addAdditionalProperty("context", keyComponents[3]);
            this.addAdditionalToOp(op, parameters, "waittime", true);
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                operationResult.setSimpleResult("Success");
            }
        } else if ("add-custom-metric".equals(name)) {
            String newOperationDestination = this.getAddress().getPath() + DYNAMIC_PROVIDER + ",custom-load-metric,custom-load-metric=" + this.retrieveNewIdentifier(parameters, "class");
            op = new Operation("add", new Address(newOperationDestination));
            this.addAdditionalToOp(op, parameters, "class", false);
            this.addAdditionalToOp(op, parameters, "weight", false);
            this.addAdditionalToOp(op, parameters, "capacity", true);
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                operationResult.setSimpleResult("Success");
            }
        } else if ("remove-custom-metric".equals(name)) {
            String newOperationDestination = this.getAddress().getPath() + DYNAMIC_PROVIDER + ",custom-load-metric,custom-load-metric=" + this.retrieveNewIdentifier(parameters, "class");
            op = new Operation("remove", new Address(newOperationDestination));
            this.addAdditionalToOp(op, parameters, "class", false);
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                operationResult.setSimpleResult("Success");
            }
        } else if ("add-metric".equals(name)) {
            String newOperationDestination = this.getAddress().getPath() + DYNAMIC_PROVIDER + ",custom-load-metric,load-metric=" + this.retrieveNewIdentifier(parameters, "type");
            op = new Operation("add", new Address(newOperationDestination));
            this.addAdditionalToOp(op, parameters, "weight", false);
            this.addAdditionalToOp(op, parameters, "capacity", true);
            this.addAdditionalToOp(op, parameters, "type", false);
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                operationResult.setSimpleResult("Success");
            }
        } else if ("remove-metric".equals(name)) {
            String newOperationDestination = this.getAddress().getPath() + DYNAMIC_PROVIDER + ",custom-load-metric,load-metric=" + this.retrieveNewIdentifier(parameters, "type");
            op = new Operation("remove", new Address(newOperationDestination));
            this.addAdditionalToOp(op, parameters, "type", false);
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                operationResult.setSimpleResult("Success");
            }
        } else if ("read-proxies-configuration".equals(name)) {
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                ArrayList container = (ArrayList)result.getResult();
                if (container != null && !container.isEmpty()) {
                    Object type = container.get(0);
                    String values = "";
                    if (type instanceof String) {
                        for (int i = 0; i < container.size(); ++i) {
                            values = values + container.get(i) + ",";
                        }
                        values = values.substring(0, values.length() - 1);
                    } else {
                        values = container.toString();
                    }
                    operationResult.getComplexResults().put((Property)new PropertySimple("current-proxy-config", (Object)values));
                } else {
                    operationResult.getComplexResults().put((Property)new PropertySimple("current-proxy-config", (Object)""));
                }
            }
        } else if ("read-proxies-info".equals(name)) {
            result = this.getASConnection().execute(op);
            if (result != null && result.isSuccess()) {
                ArrayList container = (ArrayList)result.getResult();
                if (container != null && !container.isEmpty()) {
                    Object type = container.get(0);
                    String values = "";
                    if (type instanceof String) {
                        for (int i = 0; i < container.size(); ++i) {
                            values = values + container.get(i) + ",";
                        }
                        values = values.substring(0, values.length() - 1);
                    } else {
                        values = container.toString();
                    }
                    operationResult.getComplexResults().put((Property)new PropertySimple("current-proxy-info", (Object)values));
                } else {
                    operationResult.getComplexResults().put((Property)new PropertySimple("current-proxy-info", (Object)""));
                }
            }
        } else {
            result = this.getASConnection().execute(op);
            if (result.isSuccess()) {
                operationResult.setSimpleResult("Success");
            }
        }
        if (!result.isSuccess()) {
            operationResult.setErrorMessage(result.getFailureDescription());
        }
        return operationResult;
    }

    void addAdditionalToOp(Operation op, Configuration parameters, String parameterName, boolean optional) {
        String value = parameters.getSimpleValue(parameterName, null);
        if (value == null) {
            if (!optional) {
                throw new IllegalArgumentException("Required parameter [" + parameterName + "] for operation [" + op.getName() + "] is not defined.");
            }
        } else {
            op.addAdditionalProperty(parameterName, value);
        }
    }

    String retrieveNewIdentifier(Configuration parameters, String parameterName) {
        String identifier = "";
        if (parameters != null && parameterName != null && !parameterName.isEmpty()) {
            identifier = parameters.getSimpleValue(parameterName, null);
        }
        return identifier;
    }

    @Override
    public Address getAddress() {
        return new Address(this.key);
    }
}

