/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jmx;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXDiscoveryComponent
implements ResourceDiscoveryComponent {
    private static final Log log = LogFactory.getLog(JMXDiscoveryComponent.class);
    public static final String VMID_CONFIG_PROPERTY = "vmid";
    public static final String COMMAND_LINE_CONFIG_PROPERTY = "commandLine";
    public static final String CONNECTOR_ADDRESS_CONFIG_PROPERTY = "connectorAddress";
    public static final String INSTALL_URI = "installURI";
    public static final String CONNECTION_TYPE = "type";
    public static final String PARENT_TYPE = "PARENT";
    public static final String ADDITIONAL_CLASSPATH_ENTRIES = "additionalClassPathEntries";
    private static final String[] PROCESS_FILTERS = new String[]{"catalina.startup.Bootstrap"};

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        HashSet<DiscoveredResourceDetails> found = new HashSet<DiscoveredResourceDetails>();
        try {
            List processes = context.getSystemInformation().getProcesses("process|basename|match=^java.*");
            for (ProcessInfo process : processes) {
                DiscoveredResourceDetails details = this.discoverProcess(context, process);
                if (details == null) continue;
                boolean isFiltered = false;
                for (String filter : PROCESS_FILTERS) {
                    if (!details.getResourceName().contains(filter)) continue;
                    isFiltered = true;
                    break;
                }
                if (isFiltered) continue;
                found.add(details);
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to complete base jmx server discovery.", (Throwable)e);
            }
            log.warn((Object)("Unable to complete base jmx server discovery (enable DEBUG for stack): " + e));
        }
        for (Configuration c : context.getPluginConfigurations()) {
            String resourceKey = c.getSimpleValue(CONNECTOR_ADDRESS_CONFIG_PROPERTY, null);
            String connectionType = c.getSimpleValue(CONNECTION_TYPE, null);
            DiscoveredResourceDetails s = new DiscoveredResourceDetails(context.getResourceType(), resourceKey, "Java VM", "?", connectionType + " [" + resourceKey + "]", null, null);
            s.setPluginConfiguration(c);
            found.add(s);
        }
        return found;
    }

    protected DiscoveredResourceDetails discoverProcess(ResourceDiscoveryContext context, ProcessInfo process) {
        String portProp = "com.sun.management.jmxremote.port";
        String port = null;
        for (String argument : process.getCommandLine()) {
            String cmdLineArg = "-D" + portProp + "=";
            if (!argument.startsWith(cmdLineArg)) continue;
            port = argument.substring(cmdLineArg.length());
            break;
        }
        if (port == null) {
            port = process.getEnvironmentVariable(portProp);
        }
        DiscoveredResourceDetails details = null;
        if (port != null) {
            String name = "JMX Server";
            for (int i = 1; i < process.getCommandLine().length; ++i) {
                String arg = process.getCommandLine()[i];
                if (!arg.startsWith("-")) {
                    if (arg.length() >= 200) continue;
                    name = arg;
                    break;
                }
                if (!arg.equals("-cp") && !arg.equals("-classpath")) continue;
                ++i;
            }
            name = name + " (" + port + ")";
            Configuration config = context.getDefaultPluginConfiguration();
            config.put((Property)new PropertySimple(CONNECTION_TYPE, (Object)"org.mc4j.ems.connection.support.metadata.J2SE5ConnectionTypeDescriptor"));
            config.put((Property)new PropertySimple(CONNECTOR_ADDRESS_CONFIG_PROPERTY, (Object)("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/jmxrmi")));
            details = new DiscoveredResourceDetails(context.getResourceType(), port, name, null, "Standalone JVM Process", config, null);
        }
        return details;
    }
}

