/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jmx;

import java.util.HashSet;
import java.util.Set;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.support.metadata.InternalVMTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.J2SE5ConnectionTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.jmx.JMXComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedJMXServerDiscoveryComponent
implements ResourceDiscoveryComponent<JMXComponent> {
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JMXComponent> context) {
        HashSet<DiscoveredResourceDetails> found = new HashSet<DiscoveredResourceDetails>();
        Configuration configuration = context.getDefaultPluginConfiguration();
        EmsConnection emsConnection = ((JMXComponent)context.getParentResourceComponent()).getEmsConnection();
        if (emsConnection.getConnectionProvider().getConnectionSettings().getConnectionType() instanceof InternalVMTypeDescriptor) {
            configuration.put((Property)new PropertySimple("connectorAddress", (Object)"Local Connection"));
            configuration.put((Property)new PropertySimple("type", (Object)InternalVMTypeDescriptor.class.getName()));
        } else {
            boolean isJmxRemote = false;
            String jmxRemotePort = "3001";
            ProcessInfo nativeProcess = context.getParentResourceContext().getNativeProcess();
            if (nativeProcess != null) {
                String[] commandLine;
                for (String item : commandLine = nativeProcess.getCommandLine()) {
                    if (!item.contains("jmxremote.port")) continue;
                    isJmxRemote = true;
                    jmxRemotePort = item.substring(item.indexOf(61) + 1);
                }
            }
            if (isJmxRemote) {
                configuration.put((Property)new PropertySimple("type", (Object)J2SE5ConnectionTypeDescriptor.class.getName()));
                J2SE5ConnectionTypeDescriptor desc = new J2SE5ConnectionTypeDescriptor();
                String url = desc.getDefaultServerUrl();
                url = url.replace("8999", jmxRemotePort);
                configuration.put((Property)new PropertySimple("connectorAddress", (Object)url));
            } else {
                configuration.put((Property)new PropertySimple("type", (Object)"PARENT"));
            }
        }
        if (emsConnection.getBean("java.lang:type=OperatingSystem") != null) {
            DiscoveredResourceDetails s = new DiscoveredResourceDetails(context.getResourceType(), "JVM", context.getResourceType().getName(), System.getProperty("java.version"), context.getResourceType().getDescription(), configuration, null);
            found.add(s);
        }
        return found;
    }
}

