/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jmx;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.ConnectionFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.local.LocalVMFinder;
import org.mc4j.ems.connection.local.LocalVirtualMachine;
import org.mc4j.ems.connection.settings.ConnectionSettings;
import org.mc4j.ems.connection.support.ConnectionProvider;
import org.mc4j.ems.connection.support.metadata.ConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.J2SE5ConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.LocalVMTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.JMXDiscoveryComponent;

public class JMXServerComponent
implements JMXComponent {
    private static Log log = LogFactory.getLog(JMXServerComponent.class);
    private EmsConnection connection;
    private ConnectionProvider connectionProvider;
    ResourceContext context;

    public void start(ResourceContext context) throws Exception {
        this.context = context;
        log.info((Object)("Starting connection to JMX Server " + context.getResourceKey()));
        try {
            this.internalStart();
        }
        catch (Exception e) {
            log.warn((Object)"JMX Plugin connection failure", (Throwable)e);
        }
        if (this.connection == null) {
            log.warn((Object)("Unable to connect to JMX Server " + context.getResourceKey()));
        }
    }

    protected void internalStart() throws Exception {
        Configuration configuration = this.context.getPluginConfiguration();
        String connectionTypeDescriptorClass = configuration.getSimple("type").getStringValue();
        if (LocalVMTypeDescriptor.class.getName().equals(connectionTypeDescriptorClass)) {
            String commandLine = configuration.getSimple("commandLine").getStringValue();
            Map vms = LocalVMFinder.getManageableVirtualMachines();
            if (vms != null) {
                for (LocalVirtualMachine vm : vms.values()) {
                    if (!vm.getCommandLine().equals(commandLine)) continue;
                    this.connectLocal(vm.getVmid());
                }
            }
        } else if ("PARENT".equals(connectionTypeDescriptorClass)) {
            this.connection = ((JMXComponent)this.context.getParentResourceComponent()).getEmsConnection();
            this.connectionProvider = this.connection.getConnectionProvider();
        } else if (J2SE5ConnectionTypeDescriptor.class.getName().equals(connectionTypeDescriptorClass)) {
            String principal = null;
            String credentials = null;
            PropertySimple o = configuration.getSimple("principal");
            if (o != null) {
                principal = o.getStringValue();
            }
            if ((o = configuration.getSimple("credentials")) != null) {
                credentials = o.getStringValue();
            }
            ConnectionSettings settings = new ConnectionSettings();
            J2SE5ConnectionTypeDescriptor desc = new J2SE5ConnectionTypeDescriptor();
            settings.setConnectionType((ConnectionTypeDescriptor)desc);
            settings.setServerUrl(configuration.getSimple("connectorAddress").getStringValue());
            if (principal != null) {
                settings.setPrincipal(principal);
            }
            if (credentials != null) {
                settings.setCredentials(credentials);
            }
            this.prepareConnection(settings);
        } else {
            ConnectionSettings settings = new ConnectionSettings();
            String principal = null;
            String credentials = null;
            PropertySimple o = configuration.getSimple("principal");
            if (o != null) {
                principal = o.getStringValue();
            }
            if ((o = configuration.getSimple("credentials")) != null) {
                credentials = o.getStringValue();
            }
            settings.initializeConnectionType((ConnectionTypeDescriptor)Class.forName(connectionTypeDescriptorClass).newInstance());
            settings.setConnectionType((ConnectionTypeDescriptor)Class.forName(connectionTypeDescriptorClass).newInstance());
            settings.setServerUrl(configuration.getSimple("connectorAddress").getStringValue());
            String installPath = configuration.getSimpleValue("installURI", null);
            if (installPath != null) {
                settings.setLibraryURI(configuration.getSimple("installURI").getStringValue());
            }
            if (principal != null) {
                settings.setPrincipal(principal);
            }
            if (credentials != null) {
                settings.setCredentials(credentials);
            }
            this.prepareConnection(settings);
        }
        this.connection.loadSynchronous(false);
    }

    public void stop() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                log.error((Object)("Error closing EMS connection: " + e));
            }
            this.connection = null;
        }
    }

    protected void connectLocal(int vmid) {
        ConnectionSettings settings = new ConnectionSettings();
        settings.setConnectionType((ConnectionTypeDescriptor)new LocalVMTypeDescriptor());
        settings.setServerUrl(String.valueOf(vmid));
        this.prepareConnection(settings);
    }

    protected void prepareConnection(ConnectionSettings settings) {
        settings.getControlProperties().setProperty("mc4j.ems.CopyJarsToTemp", String.valueOf(Boolean.TRUE));
        settings.getControlProperties().setProperty("mc4j.ems.JarTempDir", this.context.getTemporaryDirectory().getAbsolutePath());
        this.addAdditionalJarsToConnectionSettings(settings);
        ConnectionFactory cf = new ConnectionFactory();
        cf.discoverServerClasses(settings);
        this.connectionProvider = cf.getConnectionProvider(settings);
        this.connection = this.connectionProvider.connect();
    }

    @Override
    public EmsConnection getEmsConnection() {
        return this.connection;
    }

    public AvailabilityType getAvailability() {
        if (this.connectionProvider == null || !this.connectionProvider.isConnected()) {
            try {
                this.internalStart();
            }
            catch (Exception e) {
                log.debug((Object)("Still unable to reconnect resource: " + this.context.getResourceKey() + " due to error: " + e.getMessage()));
            }
        }
        return this.connectionProvider != null && this.connectionProvider.isConnected() ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    protected ResourceContext getResourceContext() {
        return this.context;
    }

    public List<Resource> discoverServices(ResourceType type, Configuration defaultPluginConfiguration) {
        defaultPluginConfiguration.getSimple("objectName").getStringValue();
        return null;
    }

    private void addAdditionalJarsToConnectionSettings(ConnectionSettings settings) {
        Configuration pluginConfiguration = this.getResourceContext().getPluginConfiguration();
        List<File> additionalEntries = JMXDiscoveryComponent.getAdditionalJarsFromConfig(pluginConfiguration);
        if (additionalEntries == null || additionalEntries.size() == 0) {
            return;
        }
        ArrayList<File> settingsEntries = settings.getClassPathEntries();
        if (settingsEntries == null) {
            settingsEntries = new ArrayList<File>();
        }
        settingsEntries.addAll(additionalEntries);
        settings.setClassPathEntries(settingsEntries);
    }
}

