/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jmx;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.support.metadata.InternalVMTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.J2SE5ConnectionTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.ParentDefinedJMXServerNamingUtility;

public class EmbeddedJMXServerDiscoveryComponent
implements ResourceDiscoveryComponent<JMXComponent<?>> {
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JMXComponent<?>> context) throws Exception {
        HashSet<DiscoveredResourceDetails> discoveredServers = new HashSet<DiscoveredResourceDetails>();
        Configuration configuration = context.getDefaultPluginConfiguration();
        EmsConnection emsConnection = ((JMXComponent)context.getParentResourceComponent()).getEmsConnection();
        if (emsConnection.getConnectionProvider().getConnectionSettings().getConnectionType() instanceof InternalVMTypeDescriptor) {
            configuration.put((Property)new PropertySimple("connectorAddress", (Object)"Local Connection"));
            configuration.put((Property)new PropertySimple("type", (Object)InternalVMTypeDescriptor.class.getName()));
        } else {
            boolean isJmxRemote = false;
            String jmxRemotePort = "3001";
            ProcessInfo nativeProcess = context.getParentResourceContext().getNativeProcess();
            if (nativeProcess != null) {
                String[] commandLine;
                for (String item : commandLine = nativeProcess.getCommandLine()) {
                    if (!item.contains("jmxremote.port")) continue;
                    isJmxRemote = true;
                    jmxRemotePort = item.substring(item.indexOf(61) + 1);
                }
            }
            if (isJmxRemote) {
                configuration.put((Property)new PropertySimple("type", (Object)J2SE5ConnectionTypeDescriptor.class.getName()));
                J2SE5ConnectionTypeDescriptor desc = new J2SE5ConnectionTypeDescriptor();
                String url = desc.getDefaultServerUrl();
                url = url.replace("8999", jmxRemotePort);
                configuration.put((Property)new PropertySimple("connectorAddress", (Object)url));
            } else {
                configuration.put((Property)new PropertySimple("type", (Object)"PARENT"));
            }
        }
        EmsBean runtimeMBean = emsConnection.getBean("java.lang:type=Runtime");
        if (runtimeMBean != null) {
            String version = EmbeddedJMXServerDiscoveryComponent.getSystemProperty(runtimeMBean, "java.version");
            DiscoveredResourceDetails server = new DiscoveredResourceDetails(context.getResourceType(), "JVM", ParentDefinedJMXServerNamingUtility.getJVMName(context), version, context.getResourceType().getDescription(), configuration, null);
            discoveredServers.add(server);
        }
        return discoveredServers;
    }

    private static String getSystemProperty(EmsBean runtimeMBean, String propertyName) throws Exception {
        Object tabularDataObj = runtimeMBean.getAttribute("systemProperties").refresh();
        Method getMethod = tabularDataObj.getClass().getMethod("get", Class.forName("[Ljava.lang.Object;"));
        Object compositeDataObj = getMethod.invoke(tabularDataObj, new Object[]{new Object[]{propertyName}});
        getMethod = compositeDataObj.getClass().getMethod("get", String.class);
        String version = (String)getMethod.invoke(compositeDataObj, "value");
        return version;
    }
}

