/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mysql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashSet;
import java.util.Set;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.database.DatabaseQueryUtility;
import org.rhq.plugins.mysql.MySqlComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlDatabaseDiscoveryComponent
implements ResourceDiscoveryComponent<MySqlComponent> {
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<MySqlComponent> context) {
        LinkedHashSet<DiscoveredResourceDetails> tables = new LinkedHashSet<DiscoveredResourceDetails>();
        Connection connection = ((MySqlComponent)context.getParentResourceComponent()).getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SHOW DATABASES");
            while (resultSet.next()) {
                String databaseName = resultSet.getString(1);
                DiscoveredResourceDetails details = new DiscoveredResourceDetails(context.getResourceType(), databaseName, databaseName + " Database", null, "A MySql Database", null, null);
                tables.add(details);
            }
        }
        catch (SQLException e) {
            DatabaseQueryUtility.close((Statement)statement, resultSet);
        }
        return tables;
    }
}

