/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.oracle;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.plugins.oracle.OracleServerComponent;

public class OracleDiscoveryComponent
implements ResourceDiscoveryComponent,
ManualAddFacet {
    private static Log log = LogFactory.getLog(OracleDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext resourceDiscoveryContext) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> found = new HashSet<DiscoveredResourceDetails>();
        List autoDiscoveryResults = resourceDiscoveryContext.getAutoDiscoveredProcesses();
        for (ProcessScanResult process : autoDiscoveryResults) {
            String sid = process.getProcessInfo().getEnvironmentVariable("ORACLE_SID");
            if (sid == null || sid.length() == 0) {
                log.info((Object)"Unable to discover Oracle instance SID. Use manual inventory to complete setup.");
                continue;
            }
            String pwd = process.getProcessInfo().getExecutable().getCwd();
            String version = null;
            if (pwd.contains("10.2.0")) {
                version = "10.2.0";
            }
            Configuration pluginConfig = resourceDiscoveryContext.getDefaultPluginConfiguration().deepCopy();
            pluginConfig.put((Property)new PropertySimple("sid", (Object)sid));
            DiscoveredResourceDetails details = OracleDiscoveryComponent.createResourceDetails(resourceDiscoveryContext, pluginConfig, version, process.getProcessInfo());
            found.add(details);
        }
        return found;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfig, ResourceDiscoveryContext resourceDiscoveryContext) throws InvalidPluginConfigurationException {
        Connection connection = null;
        try {
            DiscoveredResourceDetails details;
            connection = OracleServerComponent.buildConnection(pluginConfig);
            DatabaseMetaData dbmd = connection.getMetaData();
            String version = dbmd.getDatabaseMajorVersion() + "." + dbmd.getDatabaseMinorVersion();
            DiscoveredResourceDetails discoveredResourceDetails = details = OracleDiscoveryComponent.createResourceDetails(resourceDiscoveryContext, pluginConfig, version, null);
            return discoveredResourceDetails;
        }
        catch (Exception e) {
            log.warn((Object)"Could not connect to oracle with supplied configuration", (Throwable)e);
            throw new InvalidPluginConfigurationException("Unable to connect to Oracle", (Throwable)e);
        }
        finally {
            JDBCUtil.safeClose((Connection)connection);
        }
    }

    private static DiscoveredResourceDetails createResourceDetails(ResourceDiscoveryContext discoveryContext, Configuration pluginConfig, String version, @Nullable ProcessInfo processInfo) {
        String key;
        String name = key = pluginConfig.getSimpleValue("sid", "XE");
        String description = "Oracle " + version + " (" + key + ")";
        return new DiscoveredResourceDetails(discoveryContext.getResourceType(), key, name, version, description, pluginConfig, processInfo);
    }
}

