/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.oracle;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabaseQueryUtility;

public class OracleServerComponent
implements DatabaseComponent,
MeasurementFacet {
    private static final Log LOG = LogFactory.getLog(OracleServerComponent.class);
    private Connection connection;
    private ResourceContext resourceContext;
    private boolean started;

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
        this.connection = OracleServerComponent.buildConnection(resourceContext.getPluginConfiguration());
        this.started = true;
    }

    public void stop() {
        this.removeConnection();
        this.started = false;
    }

    public AvailabilityType getAvailability() {
        if (this.started && this.getConnection() != null) {
            return AvailabilityType.UP;
        }
        return AvailabilityType.DOWN;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        Map values = DatabaseQueryUtility.getNumericQueryValueMap((DatabaseComponent)this, (String)"SELECT name, value FROM V$SYSSTAT", (Object[])new Object[0]);
        for (MeasurementScheduleRequest request : metrics) {
            if (request.getName().equals("totalSize")) {
                Double val = DatabaseQueryUtility.getSingleNumericQueryValue((DatabaseComponent)this, (String)"SELECT SUM(bytes) FROM SYS.DBA_DATA_FILES", (Object[])new Object[0]);
                report.addData(new MeasurementDataNumeric(request, val));
                continue;
            }
            Double value = (Double)values.get(request.getName());
            if (value == null) continue;
            report.addData(new MeasurementDataNumeric(request, value));
        }
    }

    public Connection getConnection() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.connection = OracleServerComponent.buildConnection(this.resourceContext.getPluginConfiguration());
            }
        }
        catch (SQLException e) {
            LOG.info((Object)"Unable to create oracle connection", (Throwable)e);
        }
        return this.connection;
    }

    public void removeConnection() {
        JDBCUtil.safeClose((Connection)this.connection);
        this.connection = null;
    }

    public static Connection buildConnection(Configuration configuration) throws SQLException {
        String driverClass = configuration.getSimple("driverClass").getStringValue();
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidPluginConfigurationException("Specified JDBC driver class (" + driverClass + ") not found.");
        }
        String url = OracleServerComponent.buildUrl(configuration);
        LOG.debug((Object)("Attempting JDBC connection to [" + url + "]"));
        String principal = configuration.getSimple("principal").getStringValue();
        String credentials = configuration.getSimple("credentials").getStringValue();
        Properties props = new Properties();
        props.put("user", principal);
        props.put("password", credentials);
        if (principal.equalsIgnoreCase("SYS")) {
            props.put("internal_logon", "sysdba");
        }
        return DriverManager.getConnection(url, props);
    }

    private static String buildUrl(Configuration configuration) {
        String connMethod = configuration.getSimpleValue("connectionMethod", "SID");
        if (connMethod.equalsIgnoreCase("SID")) {
            return "jdbc:oracle:thin:@" + configuration.getSimpleValue("host", "localhost") + ":" + configuration.getSimpleValue("port", "1521") + ":" + configuration.getSimpleValue("sid", "XE");
        }
        return "jdbc:oracle:thin:@//" + configuration.getSimpleValue("host", "localhost") + ":" + configuration.getSimpleValue("port", "1521") + "/" + configuration.getSimpleValue("sid", "XE");
    }
}

