/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.perftest;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.perftest.ScenarioManager;
import org.rhq.plugins.perftest.resource.ResourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfTestRogueDiscoveryComponent
implements ResourceDiscoveryComponent {
    private Log log = LogFactory.getLog(PerfTestRogueDiscoveryComponent.class);
    private static final String SYSPROP_DISCOVERY = "on.perftest.server-rogue-discovery";
    private static final String SYSPROP_DISCOVERY_INT = "on.perftest.server-rogue-discovery-interruptable";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) throws InvalidPluginConfigurationException, Exception {
        ResourceType resourceType = context.getResourceType();
        ScenarioManager manager = ScenarioManager.getInstance();
        Set<DiscoveredResourceDetails> allResourceDetails = null;
        if (manager.isEnabled()) {
            ResourceFactory resourceFactory = manager.getResourceFactory(resourceType.getName());
            allResourceDetails = resourceFactory.discoverResources(context);
            String value = System.getProperty(SYSPROP_DISCOVERY);
            if (value != null) {
                if (value.equalsIgnoreCase("error")) {
                    throw new Exception("The rogue discovery component was configured to throw this exception");
                }
                try {
                    long ms = Long.parseLong(value);
                    this.log.info((Object)("The rogue discovery component was told to sleep: " + ms + "ms"));
                    this.sleep(ms);
                    this.log.info((Object)("The rogue discovery component has finished its sleep of " + ms + "ms"));
                }
                catch (Exception e) {
                    throw new InvalidPluginConfigurationException("The rogue discovery component was configured to throw this invalid config exception", (Throwable)e);
                }
            } else {
                this.log.info((Object)"The rogue discovery component was not configured to do anything bad - returning normally");
            }
        }
        return allResourceDetails;
    }

    private void sleep(long ms) {
        long start = System.currentTimeMillis();
        long finish = start + ms;
        while (System.currentTimeMillis() < finish) {
            try {
                Thread.sleep(finish - System.currentTimeMillis());
            }
            catch (InterruptedException e) {
                this.log.warn((Object)"The rogue discovery component was interrupted during its sleep", (Throwable)e);
                if (!Boolean.getBoolean(SYSPROP_DISCOVERY_INT)) continue;
                this.log.warn((Object)"The rogue discovery component will abort its sleep due to the interrupt");
                return;
            }
        }
    }
}

