/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.perftest;

import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.perftest.ScenarioManager;
import org.rhq.plugins.perftest.configuration.ConfigurationFactory;
import org.rhq.plugins.perftest.resource.ResourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfTestDiscoveryComponent
implements ResourceDiscoveryComponent {
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) throws InvalidPluginConfigurationException, Exception {
        ResourceType resourceType = context.getResourceType();
        ScenarioManager manager = ScenarioManager.getInstance();
        Set<DiscoveredResourceDetails> resourceDetails = null;
        if (manager.isEnabled()) {
            ResourceFactory resourceFactory = manager.getResourceFactory(resourceType.getName());
            resourceDetails = resourceFactory.discoverResources(context);
            ConfigurationFactory configurationFactory = manager.getPluginConfigurationFactory(resourceType.getName());
            if (configurationFactory != null) {
                for (DiscoveredResourceDetails details : resourceDetails) {
                    Configuration configuration = configurationFactory.generateConfiguration(resourceType.getPluginConfigurationDefinition());
                    details.setPluginConfiguration(configuration);
                }
            }
        }
        return resourceDetails;
    }
}

