/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.perftest;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.plugins.perftest.calltime.CalltimeFactory;
import org.rhq.plugins.perftest.calltime.ConfigurableCallTimeDataFactory;
import org.rhq.plugins.perftest.calltime.EmptyCalltimeFactory;
import org.rhq.plugins.perftest.calltime.SimpleCallTimeDataFactory;
import org.rhq.plugins.perftest.configuration.ConfigurationFactory;
import org.rhq.plugins.perftest.configuration.SimpleConfigurationFactory;
import org.rhq.plugins.perftest.content.ContentFactory;
import org.rhq.plugins.perftest.content.SimpleContentFactory;
import org.rhq.plugins.perftest.measurement.EmptyMeasurementFactory;
import org.rhq.plugins.perftest.measurement.MeasurementFactory;
import org.rhq.plugins.perftest.measurement.OOBNumericMeasurementFactory;
import org.rhq.plugins.perftest.measurement.SimpleNumericMeasurementFactory;
import org.rhq.plugins.perftest.resource.EmptyResourceFactory;
import org.rhq.plugins.perftest.resource.ResourceFactory;
import org.rhq.plugins.perftest.resource.SimpleResourceFactory;
import org.rhq.plugins.perftest.scenario.CalltimeGenerator;
import org.rhq.plugins.perftest.scenario.ConfigurableCallTimeDataGenerator;
import org.rhq.plugins.perftest.scenario.ConfigurationGenerator;
import org.rhq.plugins.perftest.scenario.ContentGenerator;
import org.rhq.plugins.perftest.scenario.MeasurementGenerator;
import org.rhq.plugins.perftest.scenario.OOBNumericMeasurementGenerator;
import org.rhq.plugins.perftest.scenario.Resource;
import org.rhq.plugins.perftest.scenario.ResourceGenerator;
import org.rhq.plugins.perftest.scenario.Scenario;
import org.rhq.plugins.perftest.scenario.SimpleCallTimeDataGenerator;
import org.rhq.plugins.perftest.scenario.SimpleConfigurationGenerator;
import org.rhq.plugins.perftest.scenario.SimpleContentGenerator;
import org.rhq.plugins.perftest.scenario.SimpleNumericMeasurementGenerator;
import org.rhq.plugins.perftest.scenario.SimpleResourceGenerator;
import org.rhq.plugins.perftest.scenario.SimpleTraitMeasurementGenerator;
import org.rhq.plugins.perftest.scenario.TraitGenerator;
import org.rhq.plugins.perftest.trait.EmptyTraitFactory;
import org.rhq.plugins.perftest.trait.SimpleTraitFactory;
import org.rhq.plugins.perftest.trait.TraitFactory;

public class ScenarioManager {
    private static final ScenarioManager INSTANCE = new ScenarioManager();
    public static final String SCENARIO_PROPERTY = "on.perftest.scenario";
    private static final EmptyResourceFactory EMPTY_RESOURCE_FACTORY = new EmptyResourceFactory();
    private static final EmptyMeasurementFactory EMPTY_MEASUREMENT_FACTORY = new EmptyMeasurementFactory();
    private static final EmptyCalltimeFactory EMPTY_CALLTIME_FACTORY = new EmptyCalltimeFactory();
    private static final TraitFactory EMPTY_TRAIT_FACTORY = new EmptyTraitFactory();
    private final Log log = LogFactory.getLog(ScenarioManager.class);
    private Scenario scenario;
    private Map<String, ResourceFactory> resourceFactories = new HashMap<String, ResourceFactory>();
    private Map<String, MeasurementFactory> measurementFactories = new HashMap<String, MeasurementFactory>();
    private Map<String, CalltimeFactory> calltimeFactories = new HashMap<String, CalltimeFactory>();
    private Map<String, TraitFactory> traitFactories = new HashMap<String, TraitFactory>();
    private Map<String, ConfigurationFactory> pluginConfigurationFactories = new HashMap<String, ConfigurationFactory>();
    private Map<String, ContentFactory> contentFactories = new HashMap<String, ContentFactory>();

    private ScenarioManager() {
        this.loadScenario();
    }

    public static ScenarioManager getInstance() {
        return INSTANCE;
    }

    public boolean isEnabled() {
        return this.scenario != null;
    }

    public ResourceFactory getResourceFactory(String resourceTypeName) {
        ResourceFactory resourceFactory = this.resourceFactories.get(resourceTypeName);
        if (resourceFactory == null) {
            Resource resource = this.findResource(resourceTypeName);
            if (resource == null) {
                resourceFactory = EMPTY_RESOURCE_FACTORY;
            } else {
                ResourceGenerator generator = (ResourceGenerator)resource.getResourceGenerator().getValue();
                resourceFactory = this.createResourceFactory(generator);
            }
            this.resourceFactories.put(resourceTypeName, resourceFactory);
        }
        return resourceFactory;
    }

    public MeasurementFactory getMeasurementFactory(String resourceTypeName) {
        MeasurementFactory measurementFactory = this.measurementFactories.get(resourceTypeName);
        if (measurementFactory == null) {
            Resource resource = this.findResource(resourceTypeName);
            if (resource == null) {
                measurementFactory = EMPTY_MEASUREMENT_FACTORY;
            } else {
                JAXBElement<? extends MeasurementGenerator> element = resource.getMeasurementGenerator();
                if (element == null) {
                    measurementFactory = EMPTY_MEASUREMENT_FACTORY;
                } else {
                    MeasurementGenerator generator = (MeasurementGenerator)element.getValue();
                    measurementFactory = this.createMeasurementFactory(generator);
                }
            }
            this.measurementFactories.put(resourceTypeName, measurementFactory);
        }
        return measurementFactory;
    }

    public CalltimeFactory getCalltimeFactory(String resourceTypeName) {
        CalltimeFactory calltimeFactory = this.calltimeFactories.get(resourceTypeName);
        if (calltimeFactory == null) {
            Resource resource = this.findResource(resourceTypeName);
            if (resource == null) {
                calltimeFactory = EMPTY_CALLTIME_FACTORY;
            } else {
                JAXBElement<? extends CalltimeGenerator> element = resource.getCalltimeGenerator();
                if (element == null) {
                    calltimeFactory = EMPTY_CALLTIME_FACTORY;
                } else {
                    CalltimeGenerator generator = (CalltimeGenerator)element.getValue();
                    calltimeFactory = this.createCalltimeFactory(generator);
                }
            }
            this.calltimeFactories.put(resourceTypeName, calltimeFactory);
        }
        return calltimeFactory;
    }

    public TraitFactory getTraitFactory(String resourceTypeName) {
        TraitFactory traitFactory = this.traitFactories.get(resourceTypeName);
        if (traitFactory == null) {
            Resource resource = this.findResource(resourceTypeName);
            if (resource == null) {
                traitFactory = EMPTY_TRAIT_FACTORY;
            } else {
                JAXBElement<? extends TraitGenerator> element = resource.getTraitGenerator();
                if (element == null) {
                    traitFactory = EMPTY_TRAIT_FACTORY;
                } else {
                    TraitGenerator generator = (TraitGenerator)element.getValue();
                    traitFactory = this.createTraitFactory(generator);
                }
            }
            this.traitFactories.put(resourceTypeName, traitFactory);
        }
        return traitFactory;
    }

    public ConfigurationFactory getPluginConfigurationFactory(String resourceTypeName) {
        JAXBElement<? extends ConfigurationGenerator> element;
        Resource resource;
        ConfigurationFactory configurationFactory = this.pluginConfigurationFactories.get(resourceTypeName);
        if (configurationFactory == null && (resource = this.findResource(resourceTypeName)) != null && (element = resource.getPluginConfigurationGenerator()) != null) {
            ConfigurationGenerator generator = (ConfigurationGenerator)element.getValue();
            configurationFactory = this.createConfigurationFactory(generator);
            this.pluginConfigurationFactories.put(resourceTypeName, configurationFactory);
        }
        return configurationFactory;
    }

    public ContentFactory getContentFactory(String resourceTypeName, String packageTypeName) {
        List<JAXBElement<? extends ContentGenerator>> elements;
        Resource resource;
        ContentFactory contentFactory = this.contentFactories.get(packageTypeName);
        if (contentFactory == null && (resource = this.findResource(resourceTypeName)) != null && (elements = resource.getContentGenerator()) != null) {
            for (JAXBElement<? extends ContentGenerator> element : elements) {
                ContentGenerator generator = (ContentGenerator)element.getValue();
                if (!generator.getPackageType().equals(packageTypeName)) continue;
                contentFactory = this.createContentFactory(generator);
                this.contentFactories.put(packageTypeName, contentFactory);
            }
        }
        return contentFactory;
    }

    private ResourceFactory createResourceFactory(ResourceGenerator generator) {
        if (generator instanceof SimpleResourceGenerator) {
            return new SimpleResourceFactory((SimpleResourceGenerator)generator);
        }
        return null;
    }

    private MeasurementFactory createMeasurementFactory(MeasurementGenerator generator) {
        if (generator instanceof SimpleNumericMeasurementGenerator) {
            return new SimpleNumericMeasurementFactory();
        }
        if (generator instanceof OOBNumericMeasurementGenerator) {
            return new OOBNumericMeasurementFactory();
        }
        return null;
    }

    private CalltimeFactory createCalltimeFactory(CalltimeGenerator generator) {
        if (generator instanceof SimpleCallTimeDataGenerator) {
            return new SimpleCallTimeDataFactory();
        }
        if (generator instanceof ConfigurableCallTimeDataGenerator) {
            return new ConfigurableCallTimeDataFactory((ConfigurableCallTimeDataGenerator)generator);
        }
        return null;
    }

    private TraitFactory createTraitFactory(TraitGenerator generator) {
        if (generator instanceof SimpleTraitMeasurementGenerator) {
            return new SimpleTraitFactory();
        }
        return null;
    }

    private ConfigurationFactory createConfigurationFactory(ConfigurationGenerator generator) {
        if (generator instanceof SimpleConfigurationGenerator) {
            return new SimpleConfigurationFactory();
        }
        return null;
    }

    private ContentFactory createContentFactory(ContentGenerator generator) {
        if (generator instanceof SimpleContentGenerator) {
            SimpleContentGenerator simpleGenerator = (SimpleContentGenerator)generator;
            return new SimpleContentFactory(simpleGenerator);
        }
        return null;
    }

    private Resource findResource(String resourceType) {
        List<Resource> allResources = this.scenario.getResource();
        for (Resource resource : allResources) {
            if (!resource.getType().equals(resourceType)) continue;
            return resource;
        }
        return null;
    }

    private void loadScenario() {
        JAXBContext jaxbContext;
        String scenarioName = System.getProperty(SCENARIO_PROPERTY);
        if (scenarioName == null) {
            this.log.error((Object)"Cannot find scenario name. Make sure the property on.perftest.scenario is set.");
            return;
        }
        this.log.info((Object)("Loading Performance Testing Scenario: " + scenarioName));
        ClassLoader loader = this.getClass().getClassLoader();
        URL scenarioUrl = loader.getResource(scenarioName + ".xml");
        Class<?> objectFactoryClass = null;
        try {
            objectFactoryClass = loader.loadClass("org.rhq.plugins.perftest.scenario.ObjectFactory");
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)"Error finding class ObjectFactory", (Throwable)e);
            return;
        }
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{objectFactoryClass});
        }
        catch (JAXBException e) {
            this.log.error((Object)"Could not instantiate JAXB context", (Throwable)e);
            return;
        }
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            ValidationEventCollector vec = new ValidationEventCollector();
            unmarshaller.setEventHandler((ValidationEventHandler)vec);
            this.scenario = (Scenario)unmarshaller.unmarshal(scenarioUrl);
        }
        catch (JAXBException e) {
            this.log.error((Object)"Scenario could not be loaded", (Throwable)e);
            return;
        }
    }
}

