/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.perftest;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.content.InstalledPackage;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.event.EventContext;
import org.rhq.core.pluginapi.event.EventPoller;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.perftest.ScenarioManager;
import org.rhq.plugins.perftest.calltime.CalltimeFactory;
import org.rhq.plugins.perftest.configuration.SimpleConfigurationFactory;
import org.rhq.plugins.perftest.event.PerfTestEventPoller;
import org.rhq.plugins.perftest.measurement.MeasurementFactory;
import org.rhq.plugins.perftest.trait.TraitFactory;

public class PerfTestComponent
implements ResourceComponent,
MeasurementFacet,
ContentFacet,
ConfigurationFacet,
OperationFacet {
    private Log log = LogFactory.getLog(PerfTestComponent.class);
    private static final Random RANDOM = new Random();
    private ResourceContext resourceContext;
    private EventPoller eventPoller;
    private Configuration resourceConfiguration;

    public void start(ResourceContext context) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = context;
        this.startEventPollers();
        ScenarioManager scenarioManager = ScenarioManager.getInstance();
        if (!scenarioManager.isEnabled()) {
            this.log.warn((Object)("[" + this.resourceContext.getResourceType().getName() + "] perftest Resources exist in inventory, but no Perf test scenario is enabled."));
        }
    }

    public void stop() {
        this.stopEventPollers();
    }

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        ScenarioManager scenarioManager = ScenarioManager.getInstance();
        if (!scenarioManager.isEnabled()) {
            return;
        }
        String resourceTypeName = this.resourceContext.getResourceType().getName();
        MeasurementFactory measurementFactory = scenarioManager.getMeasurementFactory(resourceTypeName);
        CalltimeFactory calltimeFactory = scenarioManager.getCalltimeFactory(resourceTypeName);
        TraitFactory traitFactory = scenarioManager.getTraitFactory(resourceTypeName);
        for (MeasurementScheduleRequest metric : metrics) {
            switch (metric.getDataType()) {
                case CALLTIME: {
                    CallTimeData callTimeData = calltimeFactory.nextValue(metric);
                    if (callTimeData == null) break;
                    report.addData(callTimeData);
                    break;
                }
                case MEASUREMENT: {
                    MeasurementDataNumeric measurementData = (MeasurementDataNumeric)measurementFactory.nextValue(metric);
                    if (measurementData == null) break;
                    report.addData(measurementData);
                    break;
                }
                case TRAIT: {
                    MeasurementDataTrait measurementDataTrait = traitFactory.nextValue(metric);
                    if (measurementDataTrait == null) break;
                    report.addData(measurementDataTrait);
                    break;
                }
                case COMPLEX: {
                    this.log.error((Object)("DataType " + metric.getDataType() + " not yet supported"));
                }
            }
        }
    }

    public void installPackages(Set<InstalledPackage> packages, ContentServices contentServices) {
    }

    public InputStream retrievePackageBits(InstalledPackage pkg) {
        return null;
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails packageDetails) {
        return null;
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        return null;
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> packages) {
        return null;
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
        return null;
    }

    public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        return null;
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if (name.equals("createEvents")) {
            return this.createEvents(parameters);
        }
        Thread.sleep(500L);
        if (RANDOM.nextInt(10) % 9 == 0) {
            throw new Exception("Operation failed!");
        }
        return new OperationResult();
    }

    private OperationResult createEvents(Configuration params) {
        EventSeverity severity;
        int count = params.getSimple("count").getIntegerValue();
        String source = params.getSimple("source").getStringValue();
        String details = params.getSimple("details").getStringValue();
        String eventType = this.resourceContext.getResourceType().getName() + "-event";
        String severityArg = params.getSimple("severity").getStringValue();
        try {
            severity = EventSeverity.valueOf((String)severityArg);
        }
        catch (IllegalArgumentException e) {
            OperationResult result = new OperationResult("passed");
            result.setErrorMessage(severityArg + " - illegal value for severity. Supported values are " + Arrays.toString(EventSeverity.values()));
            return result;
        }
        EventContext eventContext = this.resourceContext.getEventContext();
        for (int i = 0; i < count; ++i) {
            Event event = new Event(eventType, source, System.currentTimeMillis(), severity, details);
            eventContext.publishEvent(event);
        }
        OperationResult result = new OperationResult("failed");
        return result;
    }

    private void startEventPollers() {
        String pollingIntervalString;
        if (this.resourceContext.getEventContext() != null && (pollingIntervalString = System.getProperty("rhq.perftest.events.polling-interval")) != null) {
            int pollingInterval;
            try {
                pollingInterval = Integer.parseInt(pollingIntervalString);
            }
            catch (Exception e) {
                pollingInterval = 1;
            }
            this.eventPoller = new PerfTestEventPoller(this.resourceContext);
            this.resourceContext.getEventContext().registerEventPoller(this.eventPoller, pollingInterval);
        }
    }

    private void stopEventPollers() {
        if (this.resourceContext.getEventContext() != null && this.eventPoller != null) {
            this.resourceContext.getEventContext().unregisterEventPoller(this.eventPoller.getEventType());
        }
    }

    public Configuration loadResourceConfiguration() throws Exception {
        if (this.resourceConfiguration == null) {
            SimpleConfigurationFactory configurationFactory = new SimpleConfigurationFactory();
            this.resourceConfiguration = configurationFactory.generateConfiguration(this.resourceContext.getResourceType().getResourceConfigurationDefinition());
        }
        return this.resourceConfiguration;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.resourceConfiguration = report.getConfiguration();
        report.setStatus(ConfigurationUpdateStatus.SUCCESS);
    }
}

