/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform.win;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Win32Exception;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsSoftwareDelegate {
    private final Log log = LogFactory.getLog(WindowsSoftwareDelegate.class);

    public Set<ResourcePackageDetails> discoverInstalledSoftware(PackageType type) {
        HashSet<ResourcePackageDetails> installedSoftware = new HashSet<ResourcePackageDetails>();
        try {
            String[] packages;
            String uninstallList = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
            RegistryKey key = RegistryKey.LocalMachine;
            RegistryKey uninstall = key.openSubKey(uninstallList);
            for (String packageName : packages = uninstall.getSubKeyNames()) {
                RegistryKey packageKey = uninstall.openSubKey(packageName);
                String installDateString = WindowsSoftwareDelegate.getStringValue(packageKey, "InstallDate");
                String displayName = WindowsSoftwareDelegate.getStringValue(packageKey, "DisplayName");
                String version = WindowsSoftwareDelegate.getStringValue(packageKey, "DisplayVersion");
                if (displayName == null || installDateString == null || version == null) continue;
                if (version.length() == 0) {
                    version = "1";
                }
                try {
                    ResourcePackageDetails details = new ResourcePackageDetails(new PackageDetailsKey(displayName, version, type.getName(), "noarch"));
                    details.setFileCreatedDate(WindowsSoftwareDelegate.getDate(installDateString));
                    details.setInstallationTimestamp(WindowsSoftwareDelegate.getDate(installDateString).longValue());
                    details.setFileSize(Long.valueOf(packageKey.getIntValue("EstimatedSize", 0)));
                    details.setDeploymentTimeConfiguration(this.getConfigurations(packageKey));
                    installedSoftware.add(details);
                }
                catch (IllegalArgumentException e) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("Skipping windows package discovery for illegal entry [name=" + displayName + ",version=" + version + ",installDate=" + installDateString + "]"), (Throwable)e);
                }
            }
        }
        catch (Win32Exception e) {
            this.log.warn((Object)"Failed in discovery of installed Windows software.", (Throwable)e);
        }
        return installedSoftware;
    }

    private Configuration getConfigurations(RegistryKey packageKey) {
        String[] properties;
        Configuration config = new Configuration();
        for (String key : properties = new String[]{"Publisher", "Comments", "Contact", "HelpLink", "HelpTelephone", "InstallLocation", "InstallSource"}) {
            config.put((Property)new PropertySimple(key, (Object)WindowsSoftwareDelegate.getStringValue(packageKey, key)));
        }
        config.put((Property)new PropertySimple("EstimatedSize", (Object)packageKey.getIntValue("EstimatedSize", 0)));
        return config;
    }

    private static Long getDate(String dateString) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Date date = null;
        try {
            date = sdf.parse(dateString);
        }
        catch (ParseException e) {
            DateFormat df = DateFormat.getDateTimeInstance();
            try {
                date = df.parse(dateString);
            }
            catch (ParseException e1) {
                // empty catch block
            }
        }
        return date == null ? null : Long.valueOf(date.getTime());
    }

    private static String getStringValue(RegistryKey key, String name) {
        String value = key.getStringValue(name, null);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }
}

