/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.FileSystem;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.FileSystemInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.platform.PlatformComponent;

public class FileSystemDiscoveryComponent
implements ResourceDiscoveryComponent<PlatformComponent> {
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<PlatformComponent> discoveryContext) throws Exception {
        LinkedHashSet<DiscoveredResourceDetails> results = new LinkedHashSet<DiscoveredResourceDetails>();
        SystemInfo sysInfo = discoveryContext.getSystemInformation();
        if (!sysInfo.isNative()) {
            this.log.debug((Object)("Skipping " + discoveryContext.getResourceType().getName() + " discovery, since native system info is not available."));
            return results;
        }
        block5: for (FileSystemInfo fsInfo : sysInfo.getFileSystems()) {
            FileSystem fs = fsInfo.getFileSystem();
            int fsType = fs.getType();
            switch (fsType) {
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    if (!fs.getDevName().equals("lofs") && !fs.getDevName().equals("tmpfs")) continue block5;
                }
            }
            Configuration pluginConfig = discoveryContext.getDefaultPluginConfiguration();
            try {
                String key = fsInfo.getMountPoint();
                DiscoveredResourceDetails details = new DiscoveredResourceDetails(discoveryContext.getResourceType(), key, key, null, fsInfo.getFileSystem().getDevName() + ": " + fsInfo.getFileSystem().getDirName(), pluginConfig, null);
                results.add(details);
            }
            catch (Exception e) {
                this.log.error((Object)("File system discovery failed for [" + fsInfo + "]: " + e));
            }
        }
        return results;
    }
}

