/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.net.InetAddress;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.util.ObjectUtil;
import org.rhq.core.system.NetworkAdapterInfo;
import org.rhq.core.system.NetworkAdapterStats;
import org.rhq.plugins.platform.PlatformComponent;

public class NetworkAdapterComponent
implements ResourceComponent<PlatformComponent>,
MeasurementFacet {
    private final Log log = LogFactory.getLog(NetworkAdapterComponent.class);
    private ResourceContext<PlatformComponent> context;

    public void start(ResourceContext<PlatformComponent> resourceContext) {
        this.context = resourceContext;
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        if (this.getInfo().getOperationalStatus() == NetworkAdapterInfo.OperationState.UP) {
            return AvailabilityType.UP;
        }
        return AvailabilityType.DOWN;
    }

    private NetworkAdapterInfo getInfo() {
        for (NetworkAdapterInfo info : this.context.getSystemInformation().getAllNetworkAdapters()) {
            if (!this.context.getResourceKey().equals(info.getName())) continue;
            return info;
        }
        throw new RuntimeException("Could not find network adapter info [" + this.context.getResourceKey() + "]");
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) {
        NetworkAdapterInfo info = this.getInfo();
        NetworkAdapterStats stats = this.context.getSystemInformation().getNetworkAdapterStats(info.getName());
        for (MeasurementScheduleRequest request : metrics) {
            String property = request.getName();
            if (property.startsWith("Trait.net4.address")) {
                List addrs = info.getUnicastAddresses();
                String ifAddrs = addrs.size() > 0 ? ((InetAddress)addrs.get(0)).getHostAddress() : "";
                for (int i = 1; i < addrs.size(); ++i) {
                    ifAddrs = ifAddrs + "," + ((InetAddress)addrs.get(i)).getHostAddress();
                }
                report.addData(new MeasurementDataTrait(request, ifAddrs));
                continue;
            }
            if (property.equals("Trait.interfaceFlags")) {
                report.addData(new MeasurementDataTrait(request, info.getAllFlags()));
                continue;
            }
            Number number = (Number)ObjectUtil.lookupAttributeProperty((Object)stats, (String)request.getName());
            if (number == null) continue;
            report.addData(new MeasurementDataNumeric(request, Double.valueOf(number.doubleValue())));
        }
    }
}

