/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.net.InetAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.SystemInfo;

public abstract class PlatformDiscoveryComponent
implements ResourceDiscoveryComponent {
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        String version;
        if (!this.isPlatformSupported(context)) {
            return Collections.EMPTY_SET;
        }
        SystemInfo systemInfo = context.getSystemInformation();
        String key = this.determineResourceKey(context);
        String name = this.determineResourceName(context);
        String description = context.getResourceType().getDescription();
        try {
            version = systemInfo.getOperatingSystemName() + " " + systemInfo.getOperatingSystemVersion();
        }
        catch (Exception e) {
            version = "?";
        }
        Configuration config = context.getDefaultPluginConfiguration();
        this.discoverConfiguration(config);
        DiscoveredResourceDetails discoveredResource = new DiscoveredResourceDetails(context.getResourceType(), key, name, version, description, null, null);
        HashSet<DiscoveredResourceDetails> results = new HashSet<DiscoveredResourceDetails>();
        results.add(discoveredResource);
        return results;
    }

    protected void discoverConfiguration(Configuration configuration) {
    }

    protected String determineResourceKey(ResourceDiscoveryContext context) {
        String pcName;
        String resourceKey = pcName = context.getPluginContainerName();
        if (pcName == null) {
            resourceKey = this.getHostname(context.getSystemInformation());
        }
        return resourceKey;
    }

    protected String determineResourceName(ResourceDiscoveryContext context) {
        String pcName;
        String resourceName = pcName = context.getPluginContainerName();
        if (pcName == null) {
            resourceName = this.getHostname(context.getSystemInformation());
        }
        return resourceName;
    }

    protected String getHostname(SystemInfo systemInformation) {
        String name;
        try {
            name = systemInformation.getHostname();
        }
        catch (Exception e) {
            name = null;
        }
        if (name == null) {
            try {
                name = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                name = null;
            }
            if (name == null) {
                name = "Unnamed Platform";
            }
        }
        return name;
    }

    protected abstract boolean isPlatformSupported(ResourceDiscoveryContext var1);
}

