/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.event.EventPoller;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.platform.PlatformComponent;
import org.rhq.plugins.platform.win.Win32EventLogDelegate;
import org.rhq.plugins.platform.win.WindowsSoftwareDelegate;

public class WindowsPlatformComponent
extends PlatformComponent
implements ContentFacet {
    private final Log log = LogFactory.getLog(WindowsPlatformComponent.class);
    private Win32EventLogDelegate eventLogDelegate;
    private boolean enableContentDiscovery = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(ResourceContext context) {
        Boolean bool;
        PropertySimple contentProp;
        Configuration pluginConfiguration;
        block8: {
            super.start(context);
            pluginConfiguration = context.getPluginConfiguration();
            if (pluginConfiguration.getSimple("eventTrackingEnabled").getBooleanValue().booleanValue()) {
                try {
                    this.eventLogDelegate = new Win32EventLogDelegate(pluginConfiguration);
                    this.eventLogDelegate.open();
                    context.getEventContext().registerEventPoller((EventPoller)this.eventLogDelegate, 60);
                }
                catch (Throwable t) {
                    this.log.error((Object)"Failed to start the event logger. Will not be able to capture Windows events", t);
                    if (this.eventLogDelegate == null) break block8;
                    try {
                        this.eventLogDelegate.close();
                    }
                    catch (Throwable t2) {
                    }
                    finally {
                        this.eventLogDelegate = null;
                    }
                }
            }
        }
        this.enableContentDiscovery = (contentProp = pluginConfiguration.getSimple("enableContentDiscovery")) != null ? ((bool = contentProp.getBooleanValue()) != null ? bool : false) : false;
    }

    @Override
    public void stop() {
        super.stop();
        if (this.eventLogDelegate != null) {
            this.resourceContext.getEventContext().unregisterEventPoller(this.eventLogDelegate.getEventType());
            this.eventLogDelegate.close();
        }
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails packageDetails) {
        return null;
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        return null;
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> packages) {
        return null;
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
        if (this.enableContentDiscovery) {
            return new WindowsSoftwareDelegate().discoverInstalledSoftware(type);
        }
        return new HashSet<ResourcePackageDetails>();
    }

    public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        return null;
    }
}

