/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.system.AggregateProcessInfo;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.util.exception.ThrowableUtil;

public class ProcessComponent
implements ResourceComponent,
MeasurementFacet {
    private static final Log log = LogFactory.getLog(ProcessComponent.class);
    private ResourceContext resourceContext;
    private ProcessInfo process;
    private Type type;
    private String pidFile;
    private String piql;
    private boolean fullProcessTree;

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
        try {
            Configuration config = this.resourceContext.getPluginConfiguration();
            this.type = Type.valueOf(config.getSimpleValue("type", "pidFile"));
            this.pidFile = config.getSimpleValue("pidFile", null);
            this.piql = config.getSimpleValue("piql", null);
            this.fullProcessTree = config.getSimple("fullProcessTree").getBooleanValue();
        }
        catch (Exception e) {
            throw new InvalidPluginConfigurationException((Throwable)e);
        }
        if (this.type == Type.pidFile && (this.pidFile == null || this.pidFile.length() == 0)) {
            throw new InvalidPluginConfigurationException("Missing pidfile");
        }
        if (this.type == Type.piql && (this.piql == null || this.piql.length() == 0)) {
            throw new InvalidPluginConfigurationException("Missing process query");
        }
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        try {
            ProcessInfo.ProcessInfoSnapshot processInfoSnapshot;
            ProcessInfo.ProcessInfoSnapshot processInfoSnapshot2 = processInfoSnapshot = this.process == null ? null : this.process.freshSnapshot();
            if (processInfoSnapshot == null || !processInfoSnapshot.isRunning()) {
                this.process = this.getProcessForConfiguration();
                processInfoSnapshot = this.process == null ? null : this.process.priorSnaphot();
            }
            return processInfoSnapshot.isRunning() ? AvailabilityType.UP : AvailabilityType.DOWN;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("failed to get process info: " + ThrowableUtil.getAllMessages((Throwable)e)));
            }
            return AvailabilityType.DOWN;
        }
    }

    private ProcessInfo getProcessForConfiguration() throws Exception {
        SystemInfo sysInfo = this.resourceContext.getSystemInformation();
        return ProcessComponent.getProcessForConfiguration(this.type, this.pidFile, this.piql, this.fullProcessTree, sysInfo);
    }

    protected static ProcessInfo getProcessForConfiguration(Configuration config, SystemInfo systemInfo) throws Exception {
        Type type = Type.valueOf(config.getSimpleValue("type", "pidFile"));
        String pidFile = config.getSimpleValue("pidFile", null);
        String piql = config.getSimpleValue("piql", null);
        boolean fullProcessTree = config.getSimple("fullProcessTree").getBooleanValue();
        return ProcessComponent.getProcessForConfiguration(type, pidFile, piql, fullProcessTree, systemInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ProcessInfo getProcessForConfiguration(Type type, String pidFile, String piql, boolean fullProcessTree, SystemInfo systemInfo) throws Exception {
        void var7_10;
        long pid;
        if (type == Type.pidFile) {
            File file = new File(pidFile);
            if (!file.canRead()) throw new FileNotFoundException("pidfile [" + pidFile + "] does not exist or is not allowed to be read. full path=" + file.getAbsolutePath());
            FileInputStream fis = new FileInputStream(file);
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader(fis));
                pid = Long.parseLong(r.readLine());
            }
            finally {
                try {
                    fis.close();
                }
                catch (Exception ignore) {}
            }
        }
        if (type != Type.piql) throw new InvalidPluginConfigurationException("Invalid type [" + (Object)((Object)type) + "]");
        List list = systemInfo.getProcesses(piql);
        if (list == null || list.size() != 1) throw new Exception("process query [" + piql + "] did not return a single process: " + list);
        pid = ((ProcessInfo)list.get(0)).getPid();
        if (fullProcessTree) {
            AggregateProcessInfo aggregateProcessInfo = new AggregateProcessInfo(pid);
            return var7_10;
        } else {
            ProcessInfo processInfo = new ProcessInfo(pid);
        }
        return var7_10;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) {
        if (this.process != null) {
            this.process.refresh();
            for (MeasurementScheduleRequest request : metrics) {
                Object val;
                String propertyName = request.getName();
                if (!propertyName.startsWith("Process.") || (val = this.lookupAttributeProperty(this.process, (propertyName = this.convertPropertyName(propertyName, this.process)).substring("Process.".length()))) == null || !(val instanceof Number)) continue;
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(((Number)val).doubleValue())));
            }
        }
    }

    private String convertPropertyName(String propertyName, ProcessInfo theProcess) {
        if (theProcess instanceof AggregateProcessInfo) {
            propertyName = propertyName.replace(".cpu.", ".aggregateCpu.");
            propertyName = propertyName.replace(".memory.", ".aggregateMemory.");
            propertyName = propertyName.replace(".fileDescriptor.", ".aggregateFileDescriptor.");
        }
        return propertyName;
    }

    private Object lookupAttributeProperty(Object value, String property) {
        String[] ps;
        block4: {
            ps = property.split("\\.", 2);
            String searchProperty = ps[0];
            try {
                PropertyDescriptor[] pds;
                for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(value.getClass()).getPropertyDescriptors()) {
                    if (!pd.getName().equals(searchProperty)) continue;
                    value = pd.getReadMethod().invoke(value, new Object[0]);
                    break;
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)("Unable to read property [" + property + "]; measurement attribute [" + searchProperty + "] not found on [" + this.resourceContext.getResourceKey() + "]. Cause: " + e));
            }
        }
        if (ps.length > 1) {
            value = this.lookupAttributeProperty(value, ps[1]);
        }
        return value;
    }

    private static enum Type {
        pidFile,
        piql;

    }
}

