/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.plugin;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.resource.metadata.ResourceMetadataManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class InstalledPluginUIBean {
    private final Log log = LogFactory.getLog(InstalledPluginUIBean.class);
    public static final String MANAGED_BEAN_NAME = "InstalledPluginUIBean";
    private Plugin plugin;
    private ResourceMetadataManagerLocal resourceMetadataManagerBean = LookupUtil.getResourceMetadataManager();

    public InstalledPluginUIBean() {
        this.plugin = this.lookupPlugin();
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    private Plugin lookupPlugin() {
        this.hasPermission();
        String pluginName = (String)FacesContextUtility.getRequiredRequestParameter((String)"plugin", String.class);
        return this.resourceMetadataManagerBean.getPlugin(pluginName);
    }

    public void setEnabled(boolean enabled) {
    }

    public void undeploy() {
    }

    private void hasPermission() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        if (!LookupUtil.getAuthorizationManager().hasGlobalPermission(subject, Permission.MANAGE_SETTINGS)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have the proper permissions to view or manage plugins");
        }
    }
}

