/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.faces.application.FacesMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployment.scanner.URLDeploymentScannerMBean;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.core.comm.ServerCommunicationsServiceMBean;
import org.rhq.enterprise.server.core.comm.ServerCommunicationsServiceUtil;
import org.rhq.enterprise.server.resource.metadata.ResourceMetadataManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.richfaces.event.UploadEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstalledPluginsUIBean {
    private final Log log = LogFactory.getLog(InstalledPluginsUIBean.class);
    public static final String MANAGED_BEAN_NAME = "InstalledPluginsUIBean";
    private ResourceMetadataManagerLocal resourceMetadataManagerBean = LookupUtil.getResourceMetadataManager();

    public Collection<Plugin> getInstalledPlugins() {
        this.hasPermission();
        return this.resourceMetadataManagerBean.getPlugins();
    }

    public void scan() {
        this.hasPermission();
        try {
            URLDeploymentScannerMBean scanner = LookupUtil.getAgentPluginURLDeploymentScanner();
            scanner.scan();
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Done scanning for updated agent plugins.");
        }
        catch (Exception e) {
            String err = "Failed to scan for updated agent plugins";
            this.log.error((Object)(err + " - Cause: " + e));
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)err, (Throwable)e);
        }
    }

    public void fileUploadListener(UploadEvent event) {
        this.hasPermission();
        try {
            File uploadedPlugin = event.getUploadItem().getFile();
            String newPluginFilename = event.getUploadItem().getFileName();
            if (newPluginFilename != null) {
                if ((newPluginFilename = newPluginFilename.replace('\\', '/')).length() > 2 && newPluginFilename.charAt(1) == ':') {
                    newPluginFilename = newPluginFilename.substring(2);
                }
                newPluginFilename = new File(newPluginFilename).getName();
            }
            this.log.info((Object)("A new plugin [" + newPluginFilename + "] has been uploaded to [" + uploadedPlugin + "]"));
            if (uploadedPlugin == null || !uploadedPlugin.exists()) {
                throw new FileNotFoundException("The uploaded plugin file [" + uploadedPlugin + "] does not exist!");
            }
            ServerCommunicationsServiceMBean sc = ServerCommunicationsServiceUtil.getService();
            File dir = new File(sc.getConfiguration().getAgentFilesDirectory(), "rhq-plugins");
            File agentPlugin = new File(dir, newPluginFilename);
            FileOutputStream fos = new FileOutputStream(agentPlugin);
            FileInputStream fis = new FileInputStream(uploadedPlugin);
            StreamUtil.copy((InputStream)fis, (OutputStream)fos);
            this.log.info((Object)("A new plugin has been deployed [" + agentPlugin + "]. A scan is required now in order to register it."));
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("New agent plugin uploaded: " + agentPlugin));
        }
        catch (Exception e) {
            String err = "Failed to process uploaded agent plugin";
            this.log.error((Object)(err + " - Cause: " + e));
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)err, (Throwable)e);
        }
    }

    private void hasPermission() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        if (!LookupUtil.getAuthorizationManager().hasGlobalPermission(subject, Permission.MANAGE_SETTINGS)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have the proper permissions to view or manage plugins");
        }
    }
}

