/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.servlet;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.enterprise.gui.common.servlet.ImageServlet;
import org.rhq.enterprise.gui.image.chart.Chart;

public abstract class ChartServlet
extends ImageServlet {
    public static final String MEASUREMENT_UNITS_PARAM = "measurementUnits";
    public static final int IMAGE_WIDTH_DEFAULT = 755;
    public static final int IMAGE_HEIGHT_DEFAULT = 300;
    public static final String SHOW_PEAK_PARAM = "showPeak";
    public static final String SHOW_HIGHRANGE_PARAM = "showHighRange";
    public static final String SHOW_VALUES_PARAM = "showValues";
    public static final String SHOW_AVERAGE_PARAM = "showAverage";
    public static final String SHOW_LOWRANGE_PARAM = "showLowRange";
    public static final String SHOW_LOW_PARAM = "showLow";
    public static final String SHOW_BASELINE_PARAM = "showBaseline";
    public static final String BASELINE_PARAM = "baseline";
    public static final String HIGHRANGE_PARAM = "highRange";
    public static final String LOWRANGE_PARAM = "lowRange";
    private Log log = LogFactory.getLog(ChartServlet.class);
    protected MeasurementUnits units;
    private boolean showPeak;
    private boolean showHighRange;
    private boolean showValues;
    private boolean showAverage;
    private boolean showLowRange;
    private boolean showLow;
    private boolean showBaseline;
    private double baseline;
    private double highRange;
    private double lowRange;

    protected Object createImage(HttpServletRequest request) throws ServletException {
        Chart chart = this.createChart();
        this.initializeChart(chart);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Plotting data...");
        }
        this.plotData(request, chart);
        return chart;
    }

    protected void renderPngImage(ServletOutputStream out, Object imgObj) throws IOException {
        Chart chart = (Chart)imgObj;
        chart.writePngImage((OutputStream)out);
    }

    protected void renderJpegImage(ServletOutputStream out, Object imgObj) throws IOException {
        Chart chart = (Chart)imgObj;
        chart.writeJpegImage((OutputStream)out);
    }

    protected void parseParameters(HttpServletRequest request) {
        super.parseParameters(request);
        String parameter = request.getParameter(MEASUREMENT_UNITS_PARAM);
        if (parameter != null && !"".equals(parameter)) {
            this.units = MeasurementUnits.valueOf((String)parameter);
        } else if (this.units == null) {
            this.units = MeasurementUnits.NONE;
            this.log.warn((Object)"Request did not specify measurement units. Using NONE.");
        }
        this.showPeak = this.parseBooleanParameter(request, SHOW_PEAK_PARAM, this.getDefaultShowPeak());
        this.showHighRange = this.parseBooleanParameter(request, SHOW_HIGHRANGE_PARAM, this.getDefaultShowHighRange());
        this.showValues = this.parseBooleanParameter(request, SHOW_VALUES_PARAM, this.getDefaultShowValues());
        this.showAverage = this.parseBooleanParameter(request, SHOW_AVERAGE_PARAM, this.getDefaultShowAverage());
        this.showLowRange = this.parseBooleanParameter(request, SHOW_LOWRANGE_PARAM, this.getDefaultShowLowRange());
        this.showLow = this.parseBooleanParameter(request, SHOW_LOW_PARAM, this.getDefaultShowLow());
        this.showBaseline = this.parseBooleanParameter(request, SHOW_BASELINE_PARAM, this.getDefaultShowBaseline());
        if (this.showBaseline) {
            try {
                this.baseline = this.parseRequiredDoubleParameter(request, BASELINE_PARAM);
            }
            catch (IllegalArgumentException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"invalid baseline, setting showBaseline to: false");
                }
                this.showBaseline = false;
            }
        }
        if (this.showHighRange) {
            try {
                this.highRange = this.parseRequiredDoubleParameter(request, HIGHRANGE_PARAM);
            }
            catch (IllegalArgumentException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"invalid highRange, setting showHighRange to: false");
                }
                this.showHighRange = false;
            }
        }
        if (this.showLowRange) {
            try {
                this.lowRange = this.parseRequiredDoubleParameter(request, LOWRANGE_PARAM);
            }
            catch (IllegalArgumentException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"invalid lowRange, setting showLowRange to: false");
                }
                this.showLowRange = false;
            }
        }
        this._logParameters();
    }

    protected abstract Chart createChart();

    protected void initializeChart(Chart chart) {
        chart.setFormat(this.units);
        chart.showPeak = this.showPeak;
        chart.showHighRange = this.showHighRange;
        chart.showValues = this.showValues;
        chart.showAverage = this.showAverage;
        chart.showLowRange = this.showLowRange;
        chart.showLow = this.showLow;
        chart.showBaseline = this.showBaseline;
        chart.baseline = this.baseline;
        chart.highRange = this.highRange;
        chart.lowRange = this.lowRange;
    }

    protected abstract void plotData(HttpServletRequest var1, Chart var2) throws ServletException;

    public boolean getShowLow() {
        return this.showLow;
    }

    public boolean getShowPeak() {
        return this.showPeak;
    }

    public boolean getShowAvg() {
        return this.showAverage;
    }

    protected int getDefaultImageWidth() {
        return 755;
    }

    protected int getDefaultImageHeight() {
        return 300;
    }

    protected boolean getDefaultShowPeak() {
        return false;
    }

    protected boolean getDefaultShowHighRange() {
        return false;
    }

    protected boolean getDefaultShowValues() {
        return true;
    }

    protected boolean getDefaultShowAverage() {
        return false;
    }

    protected boolean getDefaultShowLowRange() {
        return false;
    }

    protected boolean getDefaultShowLow() {
        return false;
    }

    protected boolean getDefaultShowBaseline() {
        return false;
    }

    private void _logParameters() {
        if (this.log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("Parameters:");
            sb.append("\n");
            sb.append("\t");
            sb.append(MEASUREMENT_UNITS_PARAM);
            sb.append(": ");
            sb.append(this.units);
            sb.append("\n");
            sb.append("\t");
            sb.append(SHOW_PEAK_PARAM);
            sb.append(": ");
            sb.append(this.showPeak);
            sb.append("\n");
            sb.append("\t");
            sb.append(SHOW_HIGHRANGE_PARAM);
            sb.append(": ");
            sb.append(this.showHighRange);
            sb.append("\n");
            sb.append("\t");
            sb.append(SHOW_VALUES_PARAM);
            sb.append(": ");
            sb.append(this.showValues);
            sb.append("\n");
            sb.append("\t");
            sb.append(SHOW_AVERAGE_PARAM);
            sb.append(": ");
            sb.append(this.showAverage);
            sb.append("\n");
            sb.append("\t");
            sb.append(SHOW_LOWRANGE_PARAM);
            sb.append(": ");
            sb.append(this.showLowRange);
            sb.append("\n");
            sb.append("\t");
            sb.append(SHOW_LOW_PARAM);
            sb.append(": ");
            sb.append(this.showLow);
            sb.append("\n");
            sb.append("\t");
            sb.append(SHOW_BASELINE_PARAM);
            sb.append(": ");
            sb.append(this.showBaseline);
            sb.append("\n");
            sb.append("\t");
            sb.append(BASELINE_PARAM);
            sb.append(": ");
            sb.append(this.baseline);
            sb.append("\n");
            sb.append("\t");
            sb.append(HIGHRANGE_PARAM);
            sb.append(": ");
            sb.append(this.highRange);
            sb.append("\n");
            sb.append("\t");
            sb.append(LOWRANGE_PARAM);
            sb.append(": ");
            sb.append(this.lowRange);
            this.log.debug((Object)sb.toString());
        }
    }
}

