/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.time.converter;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;

/*
 * Exception performing whole class analysis ignored.
 */
public class RelativeDurationConverter
implements Converter {
    private static final long MILLIS_IN_SECOND = 1000L;
    private static final long MILLIS_IN_MINUTE = 60000L;
    private static final long MILLIS_IN_HOUR = 3600000L;
    private static final long MILLIS_IN_DAY = 86400000L;
    private static final SimpleDateFormat dayFormatter = new SimpleDateFormat("D");
    private static final SimpleDateFormat formatter = new SimpleDateFormat("hh:mm aaa z");
    public static TimeZone tz = null;

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        return null;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (value == null) {
            return "0";
        }
        long millis = 0L;
        if (value instanceof Long) {
            millis = (Long)value;
        } else if (value instanceof Double) {
            millis = ((Double)value).longValue();
        } else if (value instanceof Date) {
            millis = ((Date)value).getTime();
        } else {
            throw new IllegalArgumentException("The " + RelativeDurationConverter.class.getSimpleName() + " converter does not support rendering objects of type " + value.getClass().getSimpleName());
        }
        String result = RelativeDurationConverter.format((long)millis);
        return result;
    }

    public static String format(long eventMillis) {
        int dayOfYearToday = Integer.parseInt(dayFormatter.format(System.currentTimeMillis()));
        int dayOfYearEvent = Integer.parseInt(dayFormatter.format(eventMillis));
        String result = null;
        result = dayOfYearEvent == dayOfYearToday ? formatter.format(new Date(eventMillis)) : (dayOfYearEvent == dayOfYearToday - 1 ? "Yesterday, " + formatter.format(new Date(eventMillis)) : RelativeDurationConverter.getRelativeTimeAgo((long)eventMillis) + " ago");
        return result;
    }

    private static TimeZone getTimeZone() {
        if (tz == null) {
            return TimeZone.getDefault();
        }
        return tz;
    }

    private static String getRelativeTimeAgo(long millis) {
        StringBuilder buf = new StringBuilder();
        long timeAgo = System.currentTimeMillis() - millis;
        int count = 0;
        int days = (int)(timeAgo / 86400000L);
        timeAgo %= 86400000L;
        if (days > 0) {
            ++count;
            buf.append(days + " day");
            if (days != 1) {
                buf.append("s");
            }
        }
        int hours = (int)(timeAgo / 3600000L);
        timeAgo %= 3600000L;
        if (hours > 0) {
            ++count;
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(hours + " hour");
            if (hours != 1) {
                buf.append("s");
            }
        }
        if (count < 2) {
            int mins = (int)(timeAgo / 60000L);
            timeAgo %= 60000L;
            if (mins > 0) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(mins + " minute");
                if (mins != 1) {
                    buf.append("s");
                }
            }
        }
        return buf.toString();
    }
}

