/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.configuration.resource;

import javax.faces.application.FacesMessage;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ResourceConfigurationUpdate;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.gui.configuration.ConfigurationMaskingUtility;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.configuration.resource.AbstractResourceConfigurationUIBean;
import org.rhq.enterprise.gui.configuration.resource.ExistingResourceConfigurationUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;

public class ExistingResourceConfigurationUIBean
extends AbstractResourceConfigurationUIBean {
    public static final String MANAGED_BEAN_NAME = "ExistingResourceConfigurationUIBean";

    public ExistingResourceConfigurationUIBean() {
        this.removeSessionScopedBeanIfInView("/rhq/resource/configuration/view.xhtml", ExistingResourceConfigurationUIBean.class);
    }

    public String editConfiguration() {
        return "success";
    }

    public String updateConfiguration() {
        ConfigurationMaskingUtility.unmaskConfiguration((Configuration)this.getConfiguration(), (ConfigurationDefinition)this.getConfigurationDefinition());
        int resourceId = EnterpriseFacesContextUtility.getResource().getId();
        ResourceConfigurationUpdate updateRequest = this.configurationManager.updateResourceConfiguration(EnterpriseFacesContextUtility.getSubject(), resourceId, this.getConfiguration());
        if (updateRequest != null) {
            switch (1.$SwitchMap$org$rhq$core$domain$configuration$ConfigurationUpdateStatus[updateRequest.getStatus().ordinal()]) {
                case 1: 
                case 2: {
                    FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Configuration update request with id " + updateRequest.getId() + " has been sent to the Agent."));
                    this.clearConfiguration();
                    return "success";
                }
                case 3: {
                    FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Configuration update request with id " + updateRequest.getId() + " failed."), (String)updateRequest.getErrorMessage());
                    return "failure";
                }
            }
        } else {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)"No changes were made to the configuration, so no update request has been sent to the Agent.");
            this.clearConfiguration();
            return "success";
        }
        return null;
    }

    public String finishAddMap() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Map added.");
        return "success";
    }

    public String finishEditMap() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Map updated.");
        return "success";
    }

    protected int getConfigurationDefinitionKey() {
        return EnterpriseFacesContextUtility.getResource().getResourceType().getId();
    }

    @Nullable
    protected ConfigurationDefinition lookupConfigurationDefinition() {
        int resourceTypeId = EnterpriseFacesContextUtility.getResource().getResourceType().getId();
        ConfigurationDefinition configurationDefinition = this.configurationManager.getResourceConfigurationDefinitionForResourceType(EnterpriseFacesContextUtility.getSubject(), resourceTypeId);
        return configurationDefinition;
    }

    protected int getConfigurationKey() {
        return EnterpriseFacesContextUtility.getResource().getId();
    }

    @Nullable
    protected Configuration lookupConfiguration() {
        Configuration configuration;
        int resourceId;
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        ResourceConfigurationUpdate configurationUpdate = this.configurationManager.getLatestResourceConfigurationUpdate(subject, resourceId = EnterpriseFacesContextUtility.getResource().getId());
        Configuration configuration2 = configuration = configurationUpdate != null ? configurationUpdate.getConfiguration() : null;
        if (configuration != null) {
            ConfigurationMaskingUtility.maskConfiguration((Configuration)configuration, (ConfigurationDefinition)this.getConfigurationDefinition());
        }
        return configuration;
    }
}

