/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.AvailableResourceChannelsUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ChannelManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class AvailableResourceChannelsUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "AvailableResourceChannelsUIBean";

    public String subscribeSelectedResourceChannels() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedResourceChannels();
        int resourceId = Integer.valueOf(FacesContextUtility.getRequiredRequestParameter((String)"id"));
        int[] channelIds = this.getIntegerArray(selected);
        if (channelIds != null && channelIds.length > 0) {
            try {
                ChannelManagerLocal manager = LookupUtil.getChannelManagerLocal();
                manager.subscribeResourceToChannels(subject, resourceId, channelIds);
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Subscribed [" + channelIds.length + "] channels to resource"));
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to subscribe one or more channels to resource", (Throwable)e);
            }
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ResourceChannelsDataModel(this, PageControlView.AvailableResourceChannelsList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedResourceChannels() {
        return FacesContextUtility.getRequest().getParameterValues("selectedAvailableResourceChannels");
    }

    private int[] getIntegerArray(String[] input) {
        if (input == null) {
            return new int[0];
        }
        int[] output = new int[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = Integer.valueOf(input[i]);
        }
        return output;
    }
}

