/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import java.util.HashMap;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.ChannelAssociationsUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ChannelManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelAssociationsUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ChannelAssociationsUIBean";
    private Map<Integer, Boolean> associatedList;

    public Map<Integer, Boolean> getAssociatedList() {
        if (this.associatedList == null) {
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            int id = Integer.valueOf(FacesContextUtility.getRequiredRequestParameter((String)"id"));
            ChannelManagerLocal manager = LookupUtil.getChannelManagerLocal();
            PageList results = manager.findAssociatedContentSources(subject, id, PageControl.getUnlimitedInstance());
            this.associatedList = new HashMap(results.getTotalSize());
            for (ContentSource contentSource : results) {
                this.associatedList.put(contentSource.getId(), Boolean.TRUE);
            }
        }
        return this.associatedList;
    }

    public String deleteSelectedChannelAssociations() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedChannelAssociations();
        int channelId = Integer.valueOf(FacesContextUtility.getRequiredRequestParameter((String)"id"));
        int[] contentSourceIds = this.getIntegerArray(selected);
        if (contentSourceIds != null && contentSourceIds.length > 0) {
            try {
                ChannelManagerLocal manager = LookupUtil.getChannelManagerLocal();
                manager.removeContentSourcesFromChannel(subject, channelId, contentSourceIds);
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Disassociated [" + contentSourceIds.length + "] content sources from channel"));
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to disassociate one or more content sources from channel", (Throwable)e);
            }
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ChannelAssociationsDataModel(this, PageControlView.ChannelAssociationsList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedChannelAssociations() {
        return FacesContextUtility.getRequest().getParameterValues("selectedChannelAssociations");
    }

    private int[] getIntegerArray(String[] input) {
        if (input == null) {
            return new int[0];
        }
        int[] output = new int[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = Integer.valueOf(input[i]);
        }
        return output;
    }
}

