/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.ChannelDisassociationsUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ChannelManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ChannelDisassociationsUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ChannelDisassociationsUIBean";

    public String associateSelectedContentSourcesWithChannel() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedChannelDisassociations();
        int channelId = Integer.valueOf(FacesContextUtility.getRequiredRequestParameter((String)"id"));
        int[] contentSourceIds = this.getIntegerArray(selected);
        if (contentSourceIds != null && contentSourceIds.length > 0) {
            try {
                ChannelManagerLocal manager = LookupUtil.getChannelManagerLocal();
                manager.addContentSourcesToChannel(subject, channelId, contentSourceIds);
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Associated [" + contentSourceIds.length + "] content sources with channel"));
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to associate one or more content sources with channel", (Throwable)e);
            }
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ChannelDisassociationsDataModel(this, PageControlView.ChannelDisassociationsList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedChannelDisassociations() {
        return FacesContextUtility.getRequest().getParameterValues("selectedChannelDisassociations");
    }

    private int[] getIntegerArray(String[] input) {
        if (input == null) {
            return new int[0];
        }
        int[] output = new int[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = Integer.valueOf(input[i]);
        }
        return output;
    }
}

