/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.ChannelPackageVersionsUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ChannelManagerLocal;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ChannelPackageVersionsUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ChannelPackageVersionsUIBean";
    public static final String FORM_ID = "channelPackageVersionsListForm";
    public static final String FILTER_ID = "channelPackageVersionsListForm:packageFilter";
    private String packageFilter;

    public void installSelectedPackages() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selectedPackages = FacesContextUtility.getRequest().getParameterValues("selectedPackages");
        int channelId = Integer.valueOf(FacesContextUtility.getRequiredRequestParameter((String)"id"));
        ChannelManagerLocal channelManager = LookupUtil.getChannelManagerLocal();
        ContentManagerLocal contentManager = LookupUtil.getContentManager();
        int[] packageIds = new int[selectedPackages.length];
        for (int i = 0; i < packageIds.length; ++i) {
            packageIds[i] = Integer.parseInt(selectedPackages[i]);
        }
        try {
            PageList resources = channelManager.findSubscribedResources(subject, channelId, PageControl.getUnlimitedInstance());
            int[] resourceIds = new int[resources.size()];
            for (int i = 0; i < resourceIds.length; ++i) {
                resourceIds[i] = ((Resource)resources.get(i)).getId();
            }
            contentManager.deployPackages(subject, resourceIds, packageIds);
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to deploy packages: " + packageIds + " to resources subscribed to channel: " + channelId + " Error: " + e.getMessage()));
        }
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ChannelPackageVersionsDataModel(this, PageControlView.ChannelPackageVersionsList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    public void init() {
        if (this.packageFilter == null) {
            this.packageFilter = FacesContextUtility.getOptionalRequestParameter((String)FILTER_ID);
        }
    }

    public String getPackageFilter() {
        return this.packageFilter;
    }

    public void setPackageFilter(String packageFilter) {
        this.packageFilter = packageFilter;
    }
}

