/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.ContentSourceChannelsUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ChannelManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ContentSourceChannelsUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ContentSourceChannelsUIBean";

    public String deleteSelectedContentSourceChannels() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedContentSourceChannels();
        int contentSourceId = Integer.valueOf(FacesContextUtility.getRequiredRequestParameter((String)"id"));
        int[] channelIds = this.getIntegerArray(selected);
        if (channelIds != null && channelIds.length > 0) {
            try {
                ChannelManagerLocal manager = LookupUtil.getChannelManagerLocal();
                for (int channelId : channelIds) {
                    manager.removeContentSourcesFromChannel(subject, channelId, new int[]{contentSourceId});
                }
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Disassociated [" + channelIds.length + "] channels from content source"));
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to disassociate one or more channels from content source", (Throwable)e);
            }
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ContentSourceChannelsDataModel(this, PageControlView.ContentSourceChannelsList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedContentSourceChannels() {
        return FacesContextUtility.getRequest().getParameterValues("selectedContentSourceChannels");
    }

    private int[] getIntegerArray(String[] input) {
        if (input == null) {
            return new int[0];
        }
        int[] output = new int[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = Integer.valueOf(input[i]);
        }
        return output;
    }
}

