/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.ListChannelsUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ChannelManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ListChannelsUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ListChannelsUIBean";
    private ChannelManagerLocal channelManager = LookupUtil.getChannelManagerLocal();

    public String createNewChannel() {
        return "createNewChannel";
    }

    public String deleteSelectedChannels() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedChannels();
        Integer[] ids = this.getIntegerArray(selected);
        if (ids.length > 0) {
            try {
                for (Integer id : ids) {
                    this.channelManager.deleteChannel(subject, id.intValue());
                }
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted [" + ids.length + "] channels."));
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to delete channels.", (Throwable)e);
            }
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListChannelsDataModel(this, PageControlView.ChannelsList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedChannels() {
        return FacesContextUtility.getRequest().getParameterValues("selectedChannels");
    }

    private Integer[] getIntegerArray(String[] input) {
        if (input == null) {
            return new Integer[0];
        }
        Integer[] output = new Integer[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = Integer.valueOf(input[i]);
        }
        return output;
    }
}

