/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.image;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.rhq.enterprise.gui.image.ImageUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class WebImage {
    protected static final String ARG_CANNOT_BE_NULL = "Argument cannot be null";
    private static final String IMAGE_JPEG = "jpeg";
    private static final String IMAGE_PNG = "png";
    protected static final int DEFAULT_HEIGHT = 300;
    protected static final int DEFAULT_WIDTH = 755;
    protected static final Color DEFAULT_BACKGROUND_COLOR = Color.WHITE;
    protected static final int DEFAULT_BORDER_SIZE = 5;
    protected static final Color DEFAULT_BORDER_COLOR = Color.LIGHT_GRAY;
    protected static final Color DEFAULT_TEXT_COLOR = Color.BLACK;
    protected static final int DEFAULT_SHADOW_WIDTH = 3;
    protected static final String DEFAULT_BOLD_TYPEFACE = "sansserif.bold";
    protected static final String DEFAULT_PLAIN_TYPEFACE = "sansserif.plain";
    protected static final Font DEFAULT_FONT = new Font("sansserif.plain", 0, 11);
    protected static final FontMetrics DEFAULT_FONT_METRICS;
    public static final Font SMALL_FONT;
    private FontMetrics m_fontMetrics;
    protected Graphics2D m_graphics;
    public Font font = DEFAULT_FONT;
    public int height = 300;
    public int width = 755;
    public int leftBorder = 5;
    public int topBorder = 5;
    public int rightBorder = 5;
    public int bottomBorder = 5;
    public boolean frameImage = false;
    public Color backgroundColor = DEFAULT_BACKGROUND_COLOR;
    public Color textColor = DEFAULT_TEXT_COLOR;
    public int shadowWidth = 3;
    protected boolean antiAliased = true;
    protected boolean indexColors = false;

    protected WebImage(int width, int height) {
        this.width = width;
        this.height = height;
        this.m_fontMetrics = DEFAULT_FONT_METRICS;
    }

    protected void draw(Graphics2D g) {
        g.fillRect(0, 0, this.width + this.shadowWidth, this.height + this.shadowWidth);
        if (this.frameImage) {
            Stroke orig = g.getStroke();
            g.setStroke(new BasicStroke(2.0f, 0, 0));
            g.setColor(DEFAULT_BORDER_COLOR);
            g.drawRect(0, 0, this.width - 1, this.height - 1);
            if (this.shadowWidth > 0) {
                int[] x = new int[]{this.width + 1, this.width + 1, this.shadowWidth};
                int[] y = new int[]{this.shadowWidth, this.height + 1, this.height + 1};
                g.setColor(Color.BLACK);
                g.drawPolyline(x, y, x.length);
            }
            g.setColor(Color.WHITE);
            g.setStroke(orig);
        }
    }

    protected void preInit() {
    }

    protected void postInit(Graphics2D graphics) {
        this.initFontMetrics();
    }

    public void setBorder(int border) {
        this.topBorder = border;
        this.leftBorder = border;
        this.rightBorder = border;
        this.bottomBorder = border;
    }

    public FontMetrics getFontMetrics() {
        return this.m_fontMetrics;
    }

    public Image getImage() {
        this.preInit();
        BufferedImage image = new BufferedImage(this.width + this.shadowWidth, this.height + this.shadowWidth, 1);
        Graphics2D g = this.m_graphics = (Graphics2D)image.getGraphics();
        if (this.antiAliased) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        this.postInit(g);
        g.setColor(this.backgroundColor);
        this.draw(g);
        g.dispose();
        if (this.indexColors) {
            image = ImageUtil.convertToIndexColorImage((BufferedImage)image);
        }
        return image;
    }

    private void writeImage(String filename, String type) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(filename);
        this.writeImage((OutputStream)out, type);
        out.close();
    }

    private void writeImage(OutputStream stream, String type) throws IOException {
        ImageIO.write((RenderedImage)((BufferedImage)this.getImage()), type, stream);
        stream.flush();
    }

    public void writeJpegImage(String filename) throws FileNotFoundException, IOException {
        if (filename == null) {
            throw new IllegalArgumentException();
        }
        this.writeImage(filename, "jpeg");
    }

    public void writeJpegImage(OutputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        this.writeImage(stream, "jpeg");
    }

    public void writePngImage(String filename) throws FileNotFoundException, IOException {
        if (filename == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        this.writeImage(filename, "png");
    }

    public void writePngImage(OutputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        this.writeImage(stream, "png");
    }

    private void initFontMetrics() {
        if (this.m_graphics != null) {
            this.m_fontMetrics = this.m_graphics.getFontMetrics(this.font);
        }
    }

    protected Point getTextCenter(String text) {
        return this.getTextCenter(text, new Rectangle(0, 0, this.width, this.height));
    }

    protected Point getTextCenter(String text, Rectangle rect) {
        return WebImage.getTextCenter((String)text, (Rectangle)rect, (FontMetrics)this.m_fontMetrics);
    }

    protected static Point getTextCenter(String text, Rectangle rect, FontMetrics metrics) {
        return new Point(rect.width / 2 - metrics.stringWidth(text) / 2, rect.height / 2 + metrics.getAscent() / 2);
    }

    public static boolean isRunnable() {
        boolean res;
        try {
            GraphicsEnvironment.getLocalGraphicsEnvironment();
            res = true;
        }
        catch (InternalError e) {
            res = false;
        }
        catch (NoClassDefFoundError e) {
            res = false;
        }
        return res;
    }

    static {
        SMALL_FONT = new Font("sansserif.plain", 0, 8);
        BufferedImage img = new BufferedImage(1, 1, 12);
        Graphics g = ((Image)img).getGraphics();
        DEFAULT_FONT_METRICS = g.getFontMetrics(DEFAULT_FONT);
        g.dispose();
    }
}

