/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.image.chart;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.composite.MeasurementNumericValueAndUnits;
import org.rhq.enterprise.gui.image.chart.ChartGraphics;
import org.rhq.enterprise.gui.image.chart.DataPointCollection;
import org.rhq.enterprise.gui.image.chart.HealthChart;
import org.rhq.enterprise.gui.image.chart.HorizontalChart;
import org.rhq.enterprise.gui.image.data.IDataPoint;
import org.rhq.enterprise.gui.image.data.IStackedDataPoint;

public class PerformanceChart
extends HorizontalChart {
    private static final Color[] DEFAULT_BAR_COLORS = new Color[]{new Color(155, 186, 112), new Color(18, 179, 179), new Color(231, 90, 0)};
    protected static final int DEFAULT_BAR_HEIGHT = 7;
    private int m_cyBar;
    private Color[] m_clrBars = DEFAULT_BAR_COLORS;
    private boolean m_bHealthChart = true;
    public boolean showMinDigits = true;
    public boolean showStacked = false;

    public PerformanceChart() {
    }

    public PerformanceChart(int width, int height) {
        super(width, height);
    }

    protected void init() {
        this.m_cyBar = 7;
        this.showFullLabels = true;
        this.showRightLabels = false;
        this.showLeftLegend = false;
        this.showBottomLegend = false;
        this.valueIndent = this.m_cyBar / 2 + this.lineWidth;
        this.valueLines = 5;
        this.setFormat(MeasurementUnits.EPOCH_MILLISECONDS);
    }

    protected String[] getUnitLabels() {
        return HealthChart.getUnitStrings((DataPointCollection)this.getDataPoints(), (boolean)this.m_bHealthChart);
    }

    protected String[] getXLabels() {
        if (this.m_adRangeMarks == null) {
            return null;
        }
        if (this.showMinDigits) {
            return super.getXLabels();
        }
        String[] result = new String[this.m_adRangeMarks.length];
        for (int i = 0; i < this.m_adRangeMarks.length; ++i) {
            result[i] = new MeasurementNumericValueAndUnits(Double.valueOf(this.m_adRangeMarks[i]), this.m_fmtUnits).toString();
        }
        return result;
    }

    protected void paint(ChartGraphics g, Rectangle rect) {
        super.paint(g, rect);
        Rectangle rectBar = new Rectangle(rect.x + this.lineWidth, rect.y + this.lineWidth, 0, this.m_cyBar);
        int cDataPoints = this.getDataPoints().size();
        if (cDataPoints == 0) {
            return;
        }
        int overhang = this.m_cyBar / 2;
        Iterator iter = this.getDataPoints().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Point ptData;
            IDataPoint datapt = (IDataPoint)iter.next();
            if (!Double.isNaN(datapt.getValue()) && (ptData = this.getDataPoint(rect, i)) != null) {
                int cx = ptData.x == rectBar.x ? 1 : ptData.x - rectBar.x + this.lineWidth;
                g.graphics.setColor(this.m_clrBars[2]);
                g.graphics.fillRect(rectBar.x, ptData.y - overhang, cx, this.m_cyBar);
                if (this.showStacked && datapt instanceof IStackedDataPoint && ((IStackedDataPoint)datapt).getValues().length > 1) {
                    IStackedDataPoint sdp = (IStackedDataPoint)datapt;
                    double scale = this.scale(rect.width);
                    double[] vals = sdp.getValues();
                    if (sdp.getValues().length >= 2) {
                        double tmp = scale * (vals[1] - this.m_floor);
                        cx = (int)Math.round(tmp) + this.xOffset;
                        if (cx == 0) {
                            ++cx;
                        }
                        g.graphics.setColor(this.m_clrBars[1]);
                        g.graphics.fillRect(rectBar.x, ptData.y - overhang + 2, cx, this.m_cyBar - 2);
                    }
                    if ((cx = (int)(scale * (vals[2] - this.m_floor))) == 0) {
                        ++cx;
                    }
                    g.graphics.setColor(this.m_clrBars[0]);
                    g.graphics.fillRect(rectBar.x, ptData.y - overhang + 2, cx, this.m_cyBar - 2);
                }
            }
            ++i;
        }
    }

    protected void setHealthChart(boolean health) {
        this.m_bHealthChart = health;
    }
}

