/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.resource;

import javax.faces.application.FacesMessage;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class EditGeneralPropertiesUIBean {
    private static final String OUTCOME_SUCCESS = "success";
    private String name;
    private String description;
    private String location;
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();

    public EditGeneralPropertiesUIBean() {
        Resource resource = this.getResource();
        this.name = resource.getName();
        this.description = resource.getDescription();
        this.location = resource.getLocation();
    }

    public String begin() {
        return OUTCOME_SUCCESS;
    }

    public String update() {
        Resource resource = this.getResource();
        resource.setName(this.name);
        resource.setDescription(this.description);
        resource.setLocation(this.location);
        this.resourceManager.updateResource(EnterpriseFacesContextUtility.getSubject(), resource);
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"General properties updated.");
        return OUTCOME_SUCCESS;
    }

    private Resource getResource() {
        return this.resourceManager.getResourceById(EnterpriseFacesContextUtility.getSubject(), ((Integer)FacesContextUtility.getRequiredRequestParameter((String)"id", Integer.class)).intValue());
    }

    public String cancel() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"General properties not updated.");
        return OUTCOME_SUCCESS;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

