/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.resource;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.WebUserPreferences;
import org.rhq.enterprise.gui.legacy.action.resource.common.QuickFavoritesUtil;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.gui.util.WebUtility;

public class FavoritesUIBean {
    protected final Log log = LogFactory.getLog(FavoritesUIBean.class);
    private Boolean favorite;

    public boolean isFavorite() {
        if (this.favorite == null) {
            this.log.debug((Object)("isFavorite for " + this.getResourceId()));
            this.favorite = QuickFavoritesUtil.determineIfFavoriteResource((HttpServletRequest)FacesContextUtility.getRequest());
        }
        return this.favorite;
    }

    public String toggleFavorite() {
        this.log.debug((Object)("toggleFavorite for " + this.getResourceId()));
        WebUser user = EnterpriseFacesContextUtility.getWebUser();
        WebUserPreferences preferences = user.getWebPreferences();
        WebUserPreferences.FavoriteResourcePortletPreferences favoriteResourcePreferences = preferences.getFavoriteResourcePortletPreferences();
        int resourceId = WebUtility.getResourceId((ServletRequest)FacesContextUtility.getRequest());
        boolean isFav = favoriteResourcePreferences.isFavorite(resourceId);
        if (isFav) {
            favoriteResourcePreferences.removeFavorite(resourceId);
            this.log.debug((Object)("Removing favorite: " + resourceId));
        } else {
            favoriteResourcePreferences.addFavorite(resourceId);
            this.log.debug((Object)("Adding favorite: " + resourceId));
        }
        preferences.setFavoriteResourcePortletPreferences(favoriteResourcePreferences);
        this.favorite = !isFav;
        return null;
    }

    private int getResourceId() {
        return WebUtility.getResourceId((ServletRequest)FacesContextUtility.getRequest());
    }
}

