/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.gui.legacy.AuthenticationFilter;
import org.rhq.enterprise.gui.legacy.BaseFilter;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.util.LookupUtil;

public final class AdminUserFilter
extends BaseFilter {
    private static Log log = LogFactory.getLog(AdminUserFilter.class);

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)res;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpSession session = request.getSession();
        if (session == null) {
            throw new IllegalStateException(AdminUserFilter.class.getSimpleName() + " must be placed after " + AuthenticationFilter.class.getSimpleName() + " in the filter chain");
        }
        WebUser webUser = SessionUtils.getWebUser((HttpSession)session);
        if (webUser == null) {
            throw new IllegalStateException(AdminUserFilter.class.getSimpleName() + " must be placed after " + AuthenticationFilter.class.getSimpleName() + " in the filter chain");
        }
        String path = request.getServletPath();
        if (path.toLowerCase().startsWith("/admin/test/")) {
            Subject subject = webUser.getSubject();
            boolean isAdmin = LookupUtil.getAuthorizationManager().isSystemSuperuser(subject);
            if (!isAdmin) {
                log.info((Object)("User " + subject.getName() + " attempted unauthorized access to " + path));
                response.getWriter().write("Error: only the administrator has access to this page");
                return;
            }
        }
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException e) {
            log.warn((Object)("Caught IO Exception from client " + request.getRemoteAddr() + ": " + e.getMessage()));
        }
    }
}

