/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.AddNotificationsForm;

public class AddOthersForm
extends AddNotificationsForm {
    private Log log = LogFactory.getLog(AddOthersForm.class);
    private String emailAddresses;

    public String getEmailAddresses() {
        return this.emailAddresses;
    }

    public void setEmailAddresses(String emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(super.toString());
        s.append("ad=" + this.ad + " ");
        s.append("emailAddresses={");
        s.append(this.emailAddresses);
        s.append("} ");
        return s.toString();
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.emailAddresses = "";
        super.reset(mapping, request);
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        if (!this.shouldValidate(mapping, request)) {
            return null;
        }
        this.log.debug((Object)("validating email addresses: " + this.emailAddresses));
        ActionErrors errs = super.validate(mapping, request);
        if (null == errs && (this.emailAddresses == null || this.emailAddresses.length() == 0)) {
            return null;
        }
        errs = new ActionErrors();
        String[] emails = this.emailAddresses.split(",");
        try {
            for (int i = 0; i < emails.length; ++i) {
                String email = emails[i];
                int center = email.indexOf(64);
                if (center == -1) {
                    throw new AddressException("At-sign is missing.");
                }
                if (email.length() - center != 0) continue;
                throw new AddressException("Domain name is missing.");
            }
            InternetAddress[] addresses = InternetAddress.parse((String)this.emailAddresses, (boolean)true);
        }
        catch (AddressException e) {
            if (e.getRef() == null) {
                ActionMessage err = new ActionMessage("alert.config.error.InvalidEmailAddresses", (Object)e.getMessage());
                errs.add("emailAddresses", err);
            }
            ActionMessage err = new ActionMessage("alert.config.error.InvalidEmailAddress", (Object)e.getRef(), (Object)e.getMessage());
            errs.add("emailAddresses", err);
        }
        return errs;
    }
}

