/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.AddNotificationsAction;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.AddNotificationsForm;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.AddRolesForm;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddRolesAction
extends AddNotificationsAction {
    private Log log = LogFactory.getLog(AddRolesAction.class);

    protected ActionForward process(ActionMapping mapping, AddNotificationsForm form, HttpServletRequest request, Map<String, Integer> params) throws Exception {
        AddRolesForm addForm = (AddRolesForm)form;
        ActionForward forward = this.checkSubmit(request, mapping, (ActionForm)addForm, params);
        HttpSession session = request.getSession();
        Subject subject = RequestUtils.getSubject((HttpServletRequest)request);
        if (forward != null) {
            if (addForm.isCancelClicked() || addForm.isResetClicked()) {
                this.log.debug((Object)"removing pending role list");
                SessionUtils.removeList((HttpSession)session, (String)"PendingSessionRoles");
            } else if (addForm.isAddClicked()) {
                this.log.debug((Object)"adding to pending role list");
                SessionUtils.addToList((HttpSession)session, (String)"PendingSessionRoles", (Integer[])addForm.getAvailableRoles());
                this.log.debug((Object)("@@@@@@@@@@" + addForm.getAvailableRoles().toString()));
            } else if (addForm.isRemoveClicked()) {
                this.log.debug((Object)"removing from pending role list");
                SessionUtils.removeFromList((HttpSession)session, (String)"PendingSessionRoles", (Integer[])addForm.getPendingRoles());
            }
            return forward;
        }
        this.log.debug((Object)"getting pending role list");
        Integer[] pendingRoleIds = SessionUtils.getList((HttpSession)session, (String)"PendingSessionRoles");
        for (int i = 0; i < pendingRoleIds.length; ++i) {
            this.log.debug((Object)("adding role [" + pendingRoleIds[i] + "] for alert definition [" + addForm.getAd() + "]"));
        }
        AlertNotificationManagerLocal alertNotificationManager = LookupUtil.getAlertNotificationManager();
        alertNotificationManager.addRoleNotifications(subject, addForm.getAd(), pendingRoleIds);
        this.log.debug((Object)"remove pending role list");
        SessionUtils.removeList((HttpSession)session, (String)"PendingSessionRoles");
        RequestUtils.setConfirmation((HttpServletRequest)request, (String)"alerts.config.confirm.AddRoles");
        return this.returnSuccess(request, mapping, params);
    }
}

